<?php
/**
 * Class that operate on table 'transferclientaccounts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-09-04 12:44
 */
class TransferclientaccountsMySqlExtDAO extends TransferclientaccountsMySqlDAO{

	public function queryWithQueryString($queryString = '') {
        $sql = 'SELECT transferclientaccounts.*, clientfrom.clientname as clientfromname,
		clientto.clientname as clienttoname
		FROM transferclientaccounts JOIN client clientfrom
		ON transferclientaccounts.clientidfrom = clientfrom.clientid JOIN client clientto
		ON transferclientaccounts.clientidto = clientto.clientid
		where clientfrom.conditions = 0 and clientto.conditions = 0
                ' . $queryString . '
		order by transferid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate) {
        $sql = 'SELECT transferclientaccounts.*, clientfrom.clientname as clientfromname,
		clientto.clientname as clienttoname
		FROM transferclientaccounts JOIN client clientfrom
		ON transferclientaccounts.clientidfrom = clientfrom.clientid JOIN client clientto
		ON transferclientaccounts.clientidto = clientto.clientid
		where clientfrom.conditions = 0 and clientto.conditions = 0
		and  transferdate >= "' . $startDate . '" and transferdate <= "' . $endDate . '"
		order by transferid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOneDate($condition, $date) {
        $sql = 'SELECT transferclientaccounts.*, clientfrom.clientname as clientfromname,
		clientto.clientname as clienttoname
		FROM transferclientaccounts JOIN client clientfrom
		ON transferclientaccounts.clientidfrom = clientfrom.clientid JOIN client clientto
		ON transferclientaccounts.clientidto = clientto.clientid
		where clientfrom.conditions = 0 and clientto.conditions = 0
		and  transferdate  ' . $condition . '"' . $date . '"
		order by transferid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

	public function loadTransferById($transferid) {
        $sql = 'SELECT transferclientaccounts.*, clientfrom.clientname as clientfromname,
			clientto.clientname as clienttoname
			FROM transferclientaccounts JOIN client clientfrom
			ON transferclientaccounts.clientidfrom = clientfrom.clientid JOIN client clientto
			ON transferclientaccounts.clientidto = clientto.clientid
			where clientfrom.conditions = 0 and clientto.conditions = 0
			and transferid =' . $transferid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

	public function updateCondition($transfer) {
        $sql = 'UPDATE transferclientaccounts SET  transferdate = ?, userid = ?, conditions = ? WHERE transferid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($transfer->transferdate);
        $sqlQuery->setNumber($transfer->userid);
        $sqlQuery->setNumber($transfer->conditions);

        $sqlQuery->setNumber($transfer->transferid);
        return $this->executeUpdate($sqlQuery);
    }
}
