<?php

/**
 * Class that operate on table 'programsettings'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProgramsettingsMySqlExtDAO extends ProgramsettingsMySqlDAO {

    public function getRoundNumbersStatus() {
        $sql = 'SELECT roundnumbers FROM programsettings Where programsettingsid = 1';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function getPreviousPriceStatus() {
        $sql = 'SELECT showPreviousPrice FROM programsettings Where programsettingsid = 1';
        $sqlQuery = new SqlQuery($sql);
        return $this->QuerySingleResult($sqlQuery);
    }

    public function truncateTable() {
        $sql = 'TRUNCATE programsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function insertExt($programsetting) {
        $sql = 'INSERT INTO programsettings (programsettingsid, companyname, address, specializtion, phone, faxnumber, email, website, logo, roundnumbers, saveprinting, deptprinting, printingpapersize, userid, showPreviousPrice) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($programsetting->programsettingsid);

        $sqlQuery->set($programsetting->companyname);
        $sqlQuery->set($programsetting->address);
        $sqlQuery->set($programsetting->specializtion);
        $sqlQuery->set($programsetting->phone);
        $sqlQuery->set($programsetting->faxnumber);
        $sqlQuery->set($programsetting->email);
        $sqlQuery->set($programsetting->website);
        $sqlQuery->set($programsetting->logo);
        $sqlQuery->setNumber($programsetting->roundnumbers);
        $sqlQuery->setNumber($programsetting->saveprinting);
        $sqlQuery->setNumber($programsetting->deptprinting);
        $sqlQuery->setNumber($programsetting->printingpapersize);
        $sqlQuery->setNumber($programsetting->userid);
        $sqlQuery->setNumber($programsetting->showPreviousPrice);

        $this->executeInsert($sqlQuery);
    }

    public function alterTable() {
        $sql = "ALTER TABLE  `programsettings` ADD  `showPreviousPrice` INT NOT NULL DEFAULT  '0'";
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function updateObj($tableName, $colName, $value, $primaryCol, $id) {
        $sql = 'update ' . $tableName . ' set   ' . $colName . ' =  " ' . $value . ' " where ' . $primaryCol . ' = ' . $id;
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function truncateAllTablesGenerateQuery($DBName) {
        $sql = "SELECT Concat('TRUNCATE TABLE ', TABLE_NAME) as programsettingsid FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '" . $DBName . "' and TABLE_TYPE = 'BASE TABLE' ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function runSqlQueryGetSingleResult($sqlQuery) {
        $sql = $sqlQuery;
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function runSqlQuery($sqlQuery) {
        $sql = $sqlQuery;
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function runSqlBulk($sql) {
        $sqlQuery = new SqlQuery($sql);
        $affected_rows = $this->executeUpdate($sqlQuery, 1);
        return $affected_rows;
    }

}

?>