<?php

/**
 * Class that operate on table 'workstationassets'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
class WorkstationassetsMySqlDAO implements WorkstationassetsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WorkstationassetsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM workstationassets WHERE workstationassetsId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM workstationassets';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM workstationassets ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param workstationasset primary key
     */
    public function delete($workstationassetsId) {
        $sql = 'DELETE FROM workstationassets WHERE workstationworkstationassetsId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($workstationassetsId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WorkstationassetsMySql workstationasset
     */
    public function insert($workstationasset) {
        $sql = 'INSERT INTO workstationassets (workstationid, assetsId , workhours, efficiency) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($workstationasset->workstationid);
        $sqlQuery->set($workstationasset->assetsId);
        $sqlQuery->set($workstationasset->workhours);
        $sqlQuery->set($workstationasset->efficiency);

        $id = $this->executeInsert($sqlQuery);
        $workstationasset->workstationassetsId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param WorkstationassetsMySql workstationasset
     */
    public function update($workstationasset) {
        $sql = 'UPDATE workstationassets SET workstationid = ?, assetsId = ?, workhours = ?, efficiency = ? WHERE workstationassetsId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($workstationasset->workstationid);
        $sqlQuery->set($workstationasset->assetsId);
        $sqlQuery->set($workstationasset->workhours);
        $sqlQuery->set($workstationasset->efficiency);

        $sqlQuery->setNumber($workstationasset->workstationassetsId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM workstationassets';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByWorkstationid($value) {
        $sql = 'SELECT * FROM workstationassets WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetsId($value) {
        $sql = 'SELECT * FROM workstationassets WHERE assetsId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkhours($value) {
        $sql = 'SELECT * FROM workstationassets WHERE workhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEfficiency($value) {
        $sql = 'SELECT * FROM workstationassets WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByWorkstationid($value) {
        $sql = 'DELETE FROM workstationassets WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByassetsId($value) {
        $sql = 'DELETE FROM workstationassets WHERE assetsId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkhours($value) {
        $sql = 'DELETE FROM workstationassets WHERE workhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEfficiency($value) {
        $sql = 'DELETE FROM workstationassets WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WorkstationassetsMySql
     */
    protected function readRow($row) {
        $workstationasset = new Workstationasset();

        $workstationasset->workstationassetsId = isset($row['workstationassetsId']) ? $row['workstationassetsId'] : '';
        $workstationasset->workstationid = isset($row['workstationid']) ? $row['workstationid'] : '';
        $workstationasset->assetsId = isset($row['assetsId']) ? $row['assetsId'] : '';
        $workstationasset->workhours = isset($row['workhours']) ? $row['workhours'] : '';
        $workstationasset->efficiency = isset($row['efficiency']) ? $row['efficiency'] : '';
        $workstationasset->assetsName = isset($row['assetsName']) ? $row['assetsName'] : '';
        $workstationasset->workname = isset($row['workname']) ? $row['workname'] : '';
        $workstationasset->Hourlyrate = isset($row['Hourlyrate']) ? $row['Hourlyrate'] : '';
        $workstationasset->settingOperationrealTime = isset($row['settingOperationrealTime']) ? $row['settingOperationrealTime'] : '';

        return $workstationasset;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WorkstationassetsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>