<?php

/**
 * Class that operate on table 'workshop'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-11 09:53
 */
class WorkshopMySqlDAO implements WorkshopDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WorkshopMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM workshop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM workshop';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM workshop ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param workshop primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM workshop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WorkshopMySql workshop
     */
    public function insert($workshop) {
        $sql = 'INSERT INTO workshop (name, description, thedate, userid, del) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($workshop->name);
        $sqlQuery->setString2($workshop->description);
        $sqlQuery->set($workshop->thedate);
        $sqlQuery->setNumber($workshop->userid);
        $sqlQuery->setNumber($workshop->del);

        $id = $this->executeInsert($sqlQuery);
        $workshop->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param WorkshopMySql workshop
     */
    public function update($workshop) {
        $sql = 'UPDATE workshop SET name = ?, description = ?, thedate = ?, userid = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($workshop->name);
        $sqlQuery->setString2($workshop->description);
        $sqlQuery->set($workshop->thedate);
        $sqlQuery->setNumber($workshop->userid);
        $sqlQuery->setNumber($workshop->del);

        $sqlQuery->setNumber($workshop->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM workshop';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM workshop WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescription($value) {
        $sql = 'SELECT * FROM workshop WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThedate($value) {
        $sql = 'SELECT * FROM workshop WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM workshop WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM workshop WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM workshop WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescription($value) {
        $sql = 'DELETE FROM workshop WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThedate($value) {
        $sql = 'DELETE FROM workshop WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM workshop WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM workshop WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WorkshopMySql
     */
    protected function readRow($row) {
        $workshop = new Workshop();

        $workshop->id = isset($row['id']) ? $row['id'] : '';
        $workshop->name = isset($row['name']) ? $row['name'] : '';
        $workshop->description = isset($row['description']) ? $row['description'] : '';
        $workshop->thedate = isset($row['thedate']) ? $row['thedate'] : '';
        $workshop->userid = isset($row['userid']) ? $row['userid'] : '';
        $workshop->del = isset($row['del']) ? $row['del'] : '';

        return $workshop;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WorkshopMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>