<?php

/**
 * Class that operate on table 'toworkshoporderbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-26 14:08
 */
class ToworkshoporderbillMySqlDAO implements ToworkshoporderbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ToworkshoporderbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM toworkshoporderbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM toworkshoporderbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM toworkshoporderbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param toworkshoporderbill primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM toworkshoporderbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ToworkshoporderbillMySql toworkshoporderbill
     */
    public function insert($toworkshoporderbill) {
        $sql = 'INSERT INTO toworkshoporderbill (toworkshoporderid, billid) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($toworkshoporderbill->toworkshoporderid);
        $sqlQuery->setNumber($toworkshoporderbill->billid);

        $id = $this->executeInsert($sqlQuery);
        $toworkshoporderbill->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ToworkshoporderbillMySql toworkshoporderbill
     */
    public function update($toworkshoporderbill) {
        $sql = 'UPDATE toworkshoporderbill SET toworkshoporderid = ?, billid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($toworkshoporderbill->toworkshoporderid);
        $sqlQuery->setNumber($toworkshoporderbill->billid);

        $sqlQuery->setNumber($toworkshoporderbill->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM toworkshoporderbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByToworkshoporderid($value) {
        $sql = 'SELECT * FROM toworkshoporderbill WHERE toworkshoporderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM toworkshoporderbill WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByToworkshoporderid($value) {
        $sql = 'DELETE FROM toworkshoporderbill WHERE toworkshoporderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM toworkshoporderbill WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ToworkshoporderbillMySql
     */
    protected function readRow($row) {
        $toworkshoporderbill = new Toworkshoporderbill();

        $toworkshoporderbill->id = isset($row['id']) ? $row['id'] : '';
        $toworkshoporderbill->toworkshoporderid = isset($row['toworkshoporderid']) ? $row['toworkshoporderid'] : '';
        $toworkshoporderbill->billid = isset($row['billid']) ? $row['billid'] : '';

        return $toworkshoporderbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ToworkshoporderbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>