<?php

/**
 * Class that operate on table 'temsellbillandrutern'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemsellbillandruternMySqlDAO implements TemsellbillandruternDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemsellbillandruternMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temsellbillandrutern';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temsellbillandrutern ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temsellbillandrutern primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemsellbillandruternMySql temsellbillandrutern
     */
    public function insert($temsellbillandrutern) {
        $sql = 'INSERT INTO temsellbillandrutern (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, sellbillprice, returnsellbillprice, tempclientName, sellQuantity, returnsellQuantity, deletedsellid, controlname, tax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbillandrutern->sellbilldate);
        $sqlQuery->set($temsellbillandrutern->sellbillserial);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillclientid);
        $sqlQuery->set($temsellbillandrutern->sellbilltotaldeptbefor);
        $sqlQuery->set($temsellbillandrutern->sellbilltotaldeptafter);
        $sqlQuery->set($temsellbillandrutern->sellbilldiscount);
        $sqlQuery->setNumber($temsellbillandrutern->sellbilldiscounttype);
        $sqlQuery->set($temsellbillandrutern->sellbilltotalbill);
        $sqlQuery->set($temsellbillandrutern->sellbillaftertotalbill);
        $sqlQuery->set($temsellbillandrutern->sellbilltotalpayed);
        $sqlQuery->set($temsellbillandrutern->sellbillfinalbill);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillstoreid);
        $sqlQuery->set($temsellbillandrutern->sellbillsysdate);
        $sqlQuery->setNumber($temsellbillandrutern->userid);
        $sqlQuery->setNumber($temsellbillandrutern->conditions);
        $sqlQuery->setString2($temsellbillandrutern->sellbillclientname);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillsaveid);
        $sqlQuery->setNumber($temsellbillandrutern->sellbildirectpayment);
        $sqlQuery->setNumber($temsellbillandrutern->billnameid);
        $sqlQuery->setNumber($temsellbillandrutern->sellerid);
        $sqlQuery->set($temsellbillandrutern->sellbillprice);
        $sqlQuery->set($temsellbillandrutern->returnsellbillprice);
        $sqlQuery->set($temsellbillandrutern->tempclientName);
        $sqlQuery->set($temsellbillandrutern->sellQuantity);
        $sqlQuery->set($temsellbillandrutern->returnsellQuantity);
        $sqlQuery->setNumber($temsellbillandrutern->deletedsellid);
        $sqlQuery->set($temsellbillandrutern->controlname);
        $sqlQuery->set($temsellbillandrutern->tax);

        $id = $this->executeInsert($sqlQuery);
        $temsellbillandrutern->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemsellbillandruternMySql temsellbillandrutern
     */
    public function update($temsellbillandrutern) {
        $sql = 'UPDATE temsellbillandrutern SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, sellbillprice = ?, returnsellbillprice = ?, tempclientName = ?, sellQuantity = ?, returnsellQuantity = ?, deletedsellid = ?, controlname = ?, tax = ? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbillandrutern->sellbilldate);
        $sqlQuery->set($temsellbillandrutern->sellbillserial);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillclientid);
        $sqlQuery->set($temsellbillandrutern->sellbilltotaldeptbefor);
        $sqlQuery->set($temsellbillandrutern->sellbilltotaldeptafter);
        $sqlQuery->set($temsellbillandrutern->sellbilldiscount);
        $sqlQuery->setNumber($temsellbillandrutern->sellbilldiscounttype);
        $sqlQuery->set($temsellbillandrutern->sellbilltotalbill);
        $sqlQuery->set($temsellbillandrutern->sellbillaftertotalbill);
        $sqlQuery->set($temsellbillandrutern->sellbilltotalpayed);
        $sqlQuery->set($temsellbillandrutern->sellbillfinalbill);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillstoreid);
        $sqlQuery->set($temsellbillandrutern->sellbillsysdate);
        $sqlQuery->setNumber($temsellbillandrutern->userid);
        $sqlQuery->setNumber($temsellbillandrutern->conditions);
        $sqlQuery->setString2($temsellbillandrutern->sellbillclientname);
        $sqlQuery->setNumber($temsellbillandrutern->sellbillsaveid);
        $sqlQuery->setNumber($temsellbillandrutern->sellbildirectpayment);
        $sqlQuery->setNumber($temsellbillandrutern->billnameid);
        $sqlQuery->setNumber($temsellbillandrutern->sellerid);
        $sqlQuery->set($temsellbillandrutern->sellbillprice);
        $sqlQuery->set($temsellbillandrutern->returnsellbillprice);
        $sqlQuery->set($temsellbillandrutern->tempclientName);
        $sqlQuery->set($temsellbillandrutern->sellQuantity);
        $sqlQuery->set($temsellbillandrutern->returnsellQuantity);
        $sqlQuery->setNumber($temsellbillandrutern->deletedsellid);
        $sqlQuery->set($temsellbillandrutern->controlname);
        $sqlQuery->set($temsellbillandrutern->tax);

        $sqlQuery->setNumber($temsellbillandrutern->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temsellbillandrutern';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillprice($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellbillprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillprice($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE returnsellbillprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellQuantity($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellQuantity($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE returnsellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedsellid($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM temsellbillandrutern WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillprice($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellbillprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillprice($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE returnsellbillprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellQuantity($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellQuantity($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE returnsellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedsellid($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM temsellbillandrutern WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemsellbillandruternMySql
     */
    protected function readRow($row) {
        $temsellbillandrutern = new Temsellbillandrutern();

        $temsellbillandrutern->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $temsellbillandrutern->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $temsellbillandrutern->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $temsellbillandrutern->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $temsellbillandrutern->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $temsellbillandrutern->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $temsellbillandrutern->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $temsellbillandrutern->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $temsellbillandrutern->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $temsellbillandrutern->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $temsellbillandrutern->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $temsellbillandrutern->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $temsellbillandrutern->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $temsellbillandrutern->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $temsellbillandrutern->userid = isset($row['userid']) ? $row['userid'] : '';
        $temsellbillandrutern->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $temsellbillandrutern->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $temsellbillandrutern->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $temsellbillandrutern->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $temsellbillandrutern->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $temsellbillandrutern->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $temsellbillandrutern->sellbillprice = isset($row['sellbillprice']) ? $row['sellbillprice'] : '';
        $temsellbillandrutern->returnsellbillprice = isset($row['returnsellbillprice']) ? $row['returnsellbillprice'] : '';
        $temsellbillandrutern->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $temsellbillandrutern->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';
        $temsellbillandrutern->returnsellQuantity = isset($row['returnsellQuantity']) ? $row['returnsellQuantity'] : '';
        $temsellbillandrutern->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $temsellbillandrutern->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $temsellbillandrutern->tax = isset($row['tax']) ? $row['tax'] : '';

        return $temsellbillandrutern;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemsellbillandruternMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>