<?php

/**
 * Class that operate on table 'taskorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-18 12:20
 */
class TaskorderMySqlDAO implements TaskorderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TaskorderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM taskorder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM taskorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM taskorder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param taskorder primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM taskorder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TaskorderMySql taskorder
     */
    public function insert($taskorder) {
        $sql = 'INSERT INTO taskorder (title, startdate, enddate, productId, num, userId, thedate, conditions,clientid,file) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($taskorder->title);
        $sqlQuery->set($taskorder->startdate);
        $sqlQuery->set($taskorder->enddate);
        $sqlQuery->setNumber($taskorder->productId);
        $sqlQuery->setNumber($taskorder->num);

        $sqlQuery->setNumber($taskorder->userId);
        $sqlQuery->set($taskorder->thedate);
        $sqlQuery->setNumber($taskorder->conditions);
        $sqlQuery->setNumber($taskorder->clientid);
        $sqlQuery->set($taskorder->file);

        $id = $this->executeInsert($sqlQuery);
        $taskorder->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TaskorderMySql taskorder
     */
    public function update($taskorder) {
        $sql = 'UPDATE taskorder SET title = ?, startdate = ?, enddate = ?, productId = ?, num = ?, userId = ?, thedate = ?, conditions = ?,clientid = ?,file = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($taskorder->title);
        $sqlQuery->set($taskorder->startdate);
        $sqlQuery->set($taskorder->enddate);
        $sqlQuery->setNumber($taskorder->productId);
        $sqlQuery->setNumber($taskorder->num);


        $sqlQuery->setNumber($taskorder->userId);
        $sqlQuery->set($taskorder->thedate);
        $sqlQuery->setNumber($taskorder->conditions);
        $sqlQuery->setNumber($taskorder->clientid);
        $sqlQuery->set($taskorder->file);

        $sqlQuery->setNumber($taskorder->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM taskorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTitle($value) {
        $sql = 'SELECT * FROM taskorder WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartdate($value) {
        $sql = 'SELECT * FROM taskorder WHERE startdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEnddate($value) {
        $sql = 'SELECT * FROM taskorder WHERE enddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM taskorder WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNum($value) {
        $sql = 'SELECT * FROM taskorder WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTitle($value) {
        $sql = 'DELETE FROM taskorder WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartdate($value) {
        $sql = 'DELETE FROM taskorder WHERE startdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEnddate($value) {
        $sql = 'DELETE FROM taskorder WHERE enddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM taskorder WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNum($value) {
        $sql = 'DELETE FROM taskorder WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TaskorderMySql
     */
    protected function readRow($row) {
        $taskorder = new Taskorder();

        $taskorder->id = $row['id'];
        $taskorder->title = $row['title'];
        $taskorder->startdate = $row['startdate'];
        $taskorder->enddate = $row['enddate'];
        $taskorder->productId = $row['productId'];
        $taskorder->num = isset($row['num']) ? (float) $row['num'] : '';
        $taskorder->userId = $row['userId'];
        $taskorder->thedate = $row['thedate'];
        $taskorder->conditions = $row['conditions'];
        $taskorder->productName = $row['productName'];
        $taskorder->proCatName = $row['proCatName'];
        $taskorder->clientid = $row['clientid'];
        $taskorder->file = $row['file'];

        return $taskorder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TaskorderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>