<?php

/**
 * Class that operate on table 'sparepartstoredetails'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
class SparepartstoredetailsMySqlDAO implements SparepartstoredetailsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SparepartstoredetailsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE sparepartstoredetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sparepartstoredetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sparepartstoredetails ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sparepartstoredetail primary key
     */
    public function delete($sparepartstoredetailid) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE sparepartstoredetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sparepartstoredetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SparepartstoredetailsMySql sparepartstoredetail
     */
    public function insert($sparepartstoredetail) {
        $sql = 'INSERT INTO sparepartstoredetails (sparepartid, sparepartstoreId, partquantity, userid, sparepartstoredetaildate) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sparepartstoredetail->sparepartid);
        $sqlQuery->setNumber($sparepartstoredetail->sparepartstoreId);
        $sqlQuery->set($sparepartstoredetail->partquantity);
        $sqlQuery->setNumber($sparepartstoredetail->userid);
        $sqlQuery->set($sparepartstoredetail->sparepartstoredetaildate);

        $id = $this->executeInsert($sqlQuery);
        $sparepartstoredetail->sparepartstoredetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SparepartstoredetailsMySql sparepartstoredetail
     */
    public function update($sparepartstoredetail) {
        $sql = 'UPDATE sparepartstoredetails SET sparepartid = ?, sparepartstoreId = ?, partquantity = ?, userid = ?, sparepartstoredetaildate = ? WHERE sparepartstoredetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sparepartstoredetail->sparepartid);
        $sqlQuery->setNumber($sparepartstoredetail->sparepartstoreId);
        $sqlQuery->set($sparepartstoredetail->partquantity);
        $sqlQuery->setNumber($sparepartstoredetail->userid);
        $sqlQuery->set($sparepartstoredetail->sparepartstoredetaildate);

        $sqlQuery->setNumber($sparepartstoredetail->sparepartstoredetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sparepartstoredetails';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySparepartid($value) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartstoreId($value) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartquantity($value) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE partquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartstoredetaildate($value) {
        $sql = 'SELECT * FROM sparepartstoredetails WHERE sparepartstoredetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySparepartid($value) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartstoreId($value) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartquantity($value) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE partquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartstoredetaildate($value) {
        $sql = 'DELETE FROM sparepartstoredetails WHERE sparepartstoredetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SparepartstoredetailsMySql
     */
    protected function readRow($row) {
        $sparepartstoredetail = new Sparepartstoredetail();

        $sparepartstoredetail->sparepartstoredetailid = isset($row['sparepartstoredetailid']) ? $row['sparepartstoredetailid'] : '';
        $sparepartstoredetail->sparepartid = isset($row['sparepartid']) ? $row['sparepartid'] : '';
        $sparepartstoredetail->sparepartstoreId = isset($row['sparepartstoreId']) ? $row['sparepartstoreId'] : '';
        $sparepartstoredetail->partquantity = isset($row['partquantity']) ? $row['partquantity'] : '';
        $sparepartstoredetail->userid = isset($row['userid']) ? $row['userid'] : '';
        $sparepartstoredetail->sparepartstoredetaildate = isset($row['sparepartstoredetaildate']) ? $row['sparepartstoredetaildate'] : '';

        return $sparepartstoredetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SparepartstoredetailsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>