<?php

/**
 * Class that operate on table 'salaryreport'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-03-09 11:49
 */
class SalaryreportMySqlDAO implements SalaryreportDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SalaryreportMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM salaryreport';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM salaryreport ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param salaryreport primary key
     */
    public function delete($salaryreportid) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($salaryreportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SalaryreportMySql salaryreport
     */
    public function insert($salaryreport) {
        $sql = 'INSERT INTO salaryreport (employeeid, salaryreportdate, userid, salaryreportsalary, salaryreportdiscount, salaryreportbouns, salaryreportwithdrawal, salaryreportnet, salarymonthdate,salarymonth,Repayment,Absence,Reward,costcenterid,dailyentryid,saveid,permission,allLeave) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($salaryreport->employeeid);
        $sqlQuery->set($salaryreport->salaryreportdate);
        $sqlQuery->setNumber($salaryreport->userid);
        $sqlQuery->set($salaryreport->salaryreportsalary);
        $sqlQuery->set($salaryreport->salaryreportdiscount);
        $sqlQuery->set($salaryreport->salaryreportbouns);
        $sqlQuery->set($salaryreport->salaryreportwithdrawal);
        $sqlQuery->set($salaryreport->salaryreportnet);
        $sqlQuery->set($salaryreport->salarymonthdate);
        $sqlQuery->set($salaryreport->salarymonth);

        $sqlQuery->set($salaryreport->Repayment);
        $sqlQuery->set($salaryreport->Absence);
        $sqlQuery->set($salaryreport->Reward);
        $sqlQuery->setNumber($salaryreport->costcenterid);
        $sqlQuery->setNumber((int) $salaryreport->dailyentryid);
        $sqlQuery->setNumber($salaryreport->saveid);
        $sqlQuery->set($salaryreport->permission);
        $sqlQuery->set($salaryreport->allLeave);



        //print_r($sqlQuery);

        $id = $this->executeInsert($sqlQuery);
        $salaryreport->salaryreportid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SalaryreportMySql salaryreport
     */
    public function update($salaryreport) {
        $sql = 'UPDATE salaryreport SET employeeid = ?, salaryreportdate = ?, userid = ?, salaryreportsalary = ?, salaryreportdiscount = ?, salaryreportbouns = ?, salaryreportwithdrawal = ?, salaryreportnet = ?, salarymonthdate = ?,dailyentryid=?, saveid=? WHERE salaryreportid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($salaryreport->employeeid);
        $sqlQuery->set($salaryreport->salaryreportdate);
        $sqlQuery->setNumber($salaryreport->userid);
        $sqlQuery->set($salaryreport->salaryreportsalary);
        $sqlQuery->set($salaryreport->salaryreportdiscount);
        $sqlQuery->set($salaryreport->salaryreportbouns);
        $sqlQuery->set($salaryreport->salaryreportwithdrawal);
        $sqlQuery->set($salaryreport->salaryreportnet);
        $sqlQuery->set($salaryreport->salarymonthdate);
        $sqlQuery->set((int) $salaryreport->dailyentryid);
        $sqlQuery->set($salaryreport->saveid);

        $sqlQuery->setNumber($salaryreport->salaryreportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM salaryreport';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmployeeid($value) {
        $sql = 'SELECT * FROM salaryreport WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportdate($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM salaryreport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportsalary($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportsalary = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportdiscount($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportbouns($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportbouns = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportwithdrawal($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportwithdrawal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalaryreportnet($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salaryreportnet = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySalarymonthdate($value) {
        $sql = 'SELECT * FROM salaryreport WHERE salarymonthdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmployeeid($value) {
        $sql = 'DELETE FROM salaryreport WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportdate($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM salaryreport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportsalary($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportsalary = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportdiscount($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportbouns($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportbouns = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportwithdrawal($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportwithdrawal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalaryreportnet($value) {
        $sql = 'DELETE FROM salaryreport WHERE salaryreportnet = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySalarymonthdate($value) {
        $sql = 'DELETE FROM salaryreport WHERE salarymonthdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SalaryreportMySql
     */
    protected function readRow($row) {
        $salaryreport = new Salaryreport();

        $salaryreport->salaryreportid = isset($row['salaryreportid']) ? $row['salaryreportid'] : '';
        $salaryreport->employeeid = isset($row['employeeid']) ? $row['employeeid'] : '';
        $salaryreport->salaryreportdate = isset($row['salaryreportdate']) ? $row['salaryreportdate'] : '';
        $salaryreport->userid = isset($row['userid']) ? $row['userid'] : '';
        $salaryreport->salaryreportsalary = isset($row['salaryreportsalary']) ? $row['salaryreportsalary'] : '';
        $salaryreport->salaryreportdiscount = isset($row['salaryreportdiscount']) ? $row['salaryreportdiscount'] : '';
        $salaryreport->salaryreportbouns = isset($row['salaryreportbouns']) ? $row['salaryreportbouns'] : '';
        $salaryreport->salaryreportwithdrawal = isset($row['salaryreportwithdrawal']) ? $row['salaryreportwithdrawal'] : '';
        $salaryreport->salaryreportnet = isset($row['salaryreportnet']) ? $row['salaryreportnet'] : '';
        $salaryreport->salarymonthdate = isset($row['salarymonthdate']) ? $row['salarymonthdate'] : '';
        $salaryreport->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $salaryreport->salarymonth = isset($row['salarymonth']) ? $row['salarymonth'] : '';
        $salaryreport->Reward = isset($row['Reward']) ? $row['Reward'] : '';
        $salaryreport->employeeName = isset($row['employeeName']) ? $row['employeeName'] : '';

        $salaryreport->Repayment = isset($row['Repayment']) ? $row['Repayment'] : '';
        $salaryreport->Absence = isset($row['Absence']) ? $row['Absence'] : '';
        $salaryreport->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $salaryreport->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $salaryreport->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $salaryreport->permission = isset($row['permission']) ? $row['permission'] : '';
        $salaryreport->allLeave = isset($row['allLeave']) ? $row['allLeave'] : '';
        $salaryreport->treeId = isset($row['treeId']) ? $row['treeId'] : '';
        $salaryreport->socialInsurance = isset($row['socialInsurance']) ? $row['socialInsurance'] : '';
        $salaryreport->workTax = isset($row['workTax']) ? $row['workTax'] : '';




        return $salaryreport;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SalaryreportMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}
