<?php

/**
 * Class that operate on table 'returnsellbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnsellbillMySqlDAO implements ReturnsellbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReturnsellbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM returnsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM returnsellbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param returnsellbill primary key
     */
    public function delete($returnsellbillid) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnsellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReturnsellbillMySql returnsellbill
     */
    /*
      public function insert($returnsellbill){
      $sql = 'INSERT INTO returnsellbill (returnsellbilldate, returnsellbillserial, returnsellbillclientid, returnsellbilltotaldeptbefor, returnsellbilltotaldeptafter, returnsellbilldiscount, returnsellbilldiscounttype, returnsellbilltotalbill, returnsellbillaftertotalbill, returnsellbilltotalpayed, returnsellbillfinalbill, returnsellbillstoreid, returnsellbillsysdate, userid, conditions, returnsellbillclientname, returnsellbillsaveid, returnsellbildirectpayment, billnameid, sellerid, tempclientName, returnsellQuantity,tax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
      $sqlQuery = new SqlQuery($sql);

      $sqlQuery->set($returnsellbill->returnsellbilldate);
      $sqlQuery->set($returnsellbill->returnsellbillserial);
      $sqlQuery->setNumber($returnsellbill->returnsellbillclientid);
      $sqlQuery->set($returnsellbill->returnsellbilltotaldeptbefor);
      $sqlQuery->set($returnsellbill->returnsellbilltotaldeptafter);
      $sqlQuery->set($returnsellbill->returnsellbilldiscount);
      $sqlQuery->setNumber($returnsellbill->returnsellbilldiscounttype);
      $sqlQuery->set($returnsellbill->returnsellbilltotalbill);
      $sqlQuery->set($returnsellbill->returnsellbillaftertotalbill);
      $sqlQuery->set($returnsellbill->returnsellbilltotalpayed);
      $sqlQuery->set($returnsellbill->returnsellbillfinalbill);
      $sqlQuery->setNumber($returnsellbill->returnsellbillstoreid);
      $sqlQuery->set($returnsellbill->returnsellbillsysdate);
      $sqlQuery->setNumber($returnsellbill->userid);
      $sqlQuery->setNumber($returnsellbill->conditions);
      $sqlQuery->set($returnsellbill->returnsellbillclientname);
      $sqlQuery->setNumber($returnsellbill->returnsellbillsaveid);
      $sqlQuery->setNumber($returnsellbill->returnsellbildirectpayment);
      $sqlQuery->setNumber($returnsellbill->billnameid);
      $sqlQuery->setNumber($returnsellbill->sellerid);
      $sqlQuery->set($returnsellbill->tempclientName);
      $sqlQuery->setNumber($returnsellbill->returnsellQuantity);
      $sqlQuery->set($returnsellbill->tax);

      $id = $this->executeInsert($sqlQuery);
      $returnsellbill->returnsellbillid = $id;
      return $id;
      }
     */
    public function insert($returnsellbill) {
        $sql = 'INSERT INTO returnsellbill (returnsellbilldate, returnsellbillserial, returnsellbillclientid, returnsellbilltotaldeptbefor, returnsellbilltotaldeptafter, returnsellbilldiscount, returnsellbilldiscounttype, returnsellbilltotalbill, returnsellbillaftertotalbill, returnsellbilltotalpayed, returnsellbillfinalbill, returnsellbillstoreid, returnsellbillsysdate,comment, userid, conditions, returnsellbillclientname, returnsellbillsaveid, returnsellbildirectpayment, billnameid, sellerid, tempclientName, returnsellQuantity,tax, carnumber, cartype, carchase, carmotor,costcenterid,dailyentryid,delbyuserid,billReservation,billReservationDate,visaAccountId,cashPayed,visaPayed,isBankAccountTransfer,extraDiscountPer,extraDiscountVal,taxOfDiscountPer,taxOfDiscountVal,autoSaveFlag,obgyBillType,billoperationid,obygyVisitId,pricetype,currencyId,sellbillno,returnsellbilltypeclientid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnsellbill->returnsellbilldate);
        $sqlQuery->set($returnsellbill->returnsellbillserial);
        $sqlQuery->setNumber($returnsellbill->returnsellbillclientid);
        $sqlQuery->set($returnsellbill->returnsellbilltotaldeptbefor);
        $sqlQuery->set($returnsellbill->returnsellbilltotaldeptafter);
        $sqlQuery->set($returnsellbill->returnsellbilldiscount);
        $sqlQuery->setNumber($returnsellbill->returnsellbilldiscounttype);
        $sqlQuery->set($returnsellbill->returnsellbilltotalbill);
        $sqlQuery->set($returnsellbill->returnsellbillaftertotalbill);
        $sqlQuery->set($returnsellbill->returnsellbilltotalpayed);
        $sqlQuery->set($returnsellbill->returnsellbillfinalbill);
        $sqlQuery->setNumber($returnsellbill->returnsellbillstoreid);
        $sqlQuery->set($returnsellbill->returnsellbillsysdate);
        $sqlQuery->set($returnsellbill->comment);
        $sqlQuery->setNumber($returnsellbill->userid);
        $sqlQuery->setNumber($returnsellbill->conditions);
        $sqlQuery->set($returnsellbill->returnsellbillclientname);
        $sqlQuery->setNumber($returnsellbill->returnsellbillsaveid);
        $sqlQuery->setNumber($returnsellbill->returnsellbildirectpayment);
        $sqlQuery->setNumber($returnsellbill->billnameid);
        $sqlQuery->setNumber($returnsellbill->sellerid);
        $sqlQuery->set($returnsellbill->tempclientName);
        $sqlQuery->setNumber($returnsellbill->returnsellQuantity);
        $sqlQuery->set($returnsellbill->tax);
        $sqlQuery->set($returnsellbill->carnumber);
        $sqlQuery->set($returnsellbill->cartype);
        $sqlQuery->set($returnsellbill->carchase);
        $sqlQuery->set($returnsellbill->carmotor);
        $sqlQuery->setNumber($returnsellbill->costcenterid);
        $sqlQuery->set($returnsellbill->dailyentryid);
        $sqlQuery->setNumber((int) $returnsellbill->delbyuserid);
        $sqlQuery->setNumber((int) $returnsellbill->billReservation);
        $sqlQuery->set($returnsellbill->billReservationDate);
        $sqlQuery->setNumber((int) $returnsellbill->visaAccountId);
        $sqlQuery->setNumber((float) $returnsellbill->cashPayed);
        $sqlQuery->setNumber((float) $returnsellbill->visaPayed);
        $sqlQuery->setNumber((int) $returnsellbill->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $returnsellbill->extraDiscountPer);
        $sqlQuery->setNumber((float) $returnsellbill->extraDiscountVal);
        $sqlQuery->setNumber((float) $returnsellbill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $returnsellbill->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $returnsellbill->autoSaveFlag);
        $sqlQuery->setNumber((int) $returnsellbill->obgyBillType);
        $sqlQuery->setNumber((int) $returnsellbill->billoperationid);
        $sqlQuery->setNumber((int) $returnsellbill->obygyVisitId);
        $sqlQuery->setNumber((int) $returnsellbill->pricetype);
        $sqlQuery->setNumber((int) $returnsellbill->currencyId);
        $sqlQuery->set($returnsellbill->sellbillno);
        $sqlQuery->setNumber((int) $returnsellbill->returnsellbilltypeclientid);

        $id = $this->executeInsert($sqlQuery);
        $returnsellbill->returnsellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReturnsellbillMySql returnsellbill
     */
    public function update($returnsellbill) {
        $sql = 'UPDATE returnsellbill SET returnsellbilldate = ?, returnsellbillserial = ?, returnsellbillclientid = ?, returnsellbilltotaldeptbefor = ?, returnsellbilltotaldeptafter = ?, returnsellbilldiscount = ?, returnsellbilldiscounttype = ?, returnsellbilltotalbill = ?, returnsellbillaftertotalbill = ?, returnsellbilltotalpayed = ?, returnsellbillfinalbill = ?, returnsellbillstoreid = ?, returnsellbillsysdate = ?,comment = ?, userid = ?, conditions = ?, returnsellbillclientname = ?, returnsellbillsaveid = ?, returnsellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ? , returnsellQuantity = ? ,dailyentryid = ?,delbyuserid=?,billReservation=?,billReservationDate=?,visaAccountId = ?,cashPayed = ?,visaPayed = ?,isBankAccountTransfer = ?,extraDiscountPer=?,extraDiscountVal=?,taxOfDiscountPer=?,taxOfDiscountVal=?,autoSaveFlag=?,obgyBillType=?,billoperationid=?,obygyVisitId=?,pricetype=?,currencyId=?,sellbillno=?  WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnsellbill->returnsellbilldate);
        $sqlQuery->set($returnsellbill->returnsellbillserial);
        $sqlQuery->setNumber($returnsellbill->returnsellbillclientid);
        $sqlQuery->set($returnsellbill->returnsellbilltotaldeptbefor);
        $sqlQuery->set($returnsellbill->returnsellbilltotaldeptafter);
        $sqlQuery->set($returnsellbill->returnsellbilldiscount);
        $sqlQuery->setNumber($returnsellbill->returnsellbilldiscounttype);
        $sqlQuery->set($returnsellbill->returnsellbilltotalbill);
        $sqlQuery->set($returnsellbill->returnsellbillaftertotalbill);
        $sqlQuery->set($returnsellbill->returnsellbilltotalpayed);
        $sqlQuery->set($returnsellbill->returnsellbillfinalbill);
        $sqlQuery->setNumber($returnsellbill->returnsellbillstoreid);
        $sqlQuery->set($returnsellbill->returnsellbillsysdate);
        $sqlQuery->set($returnsellbill->comment);
        $sqlQuery->setNumber($returnsellbill->userid);
        $sqlQuery->setNumber($returnsellbill->conditions);
        $sqlQuery->set($returnsellbill->returnsellbillclientname);
        $sqlQuery->setNumber($returnsellbill->returnsellbillsaveid);
        $sqlQuery->setNumber($returnsellbill->returnsellbildirectpayment);
        $sqlQuery->setNumber($returnsellbill->billnameid);
        $sqlQuery->setNumber($returnsellbill->sellerid);
        $sqlQuery->set($returnsellbill->tempclientName);
        $sqlQuery->setNumber($returnsellbill->returnsellQuantity);
        $sqlQuery->set($returnsellbill->dailyentryid);
        $sqlQuery->setNumber($returnsellbill->delbyuserid);
        $sqlQuery->setNumber((int) $returnsellbill->billReservation);
        $sqlQuery->set($returnsellbill->billReservationDate);
        $sqlQuery->setNumber((int) $returnsellbill->visaAccountId);
        $sqlQuery->setNumber((float) $returnsellbill->cashPayed);
        $sqlQuery->setNumber((float) $returnsellbill->visaPayed);
        $sqlQuery->setNumber((int) $returnsellbill->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $returnsellbill->extraDiscountPer);
        $sqlQuery->setNumber((float) $returnsellbill->extraDiscountVal);
        $sqlQuery->setNumber((float) $returnsellbill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $returnsellbill->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $returnsellbill->autoSaveFlag);
        $sqlQuery->setNumber((int) $returnsellbill->obgyBillType);
        $sqlQuery->setNumber((int) $returnsellbill->billoperationid);
        $sqlQuery->setNumber((int) $returnsellbill->obygyVisitId);
        $sqlQuery->setNumber((int) $returnsellbill->pricetype);
        $sqlQuery->setNumber((int) $returnsellbill->currencyId);
        $sqlQuery->set($returnsellbill->sellbillno);

        $sqlQuery->setNumber($returnsellbill->returnsellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM returnsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReturnsellbilldate($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillserial($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillclientid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldiscount($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldiscounttype($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotalbill($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilltotalpayed($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillfinalbill($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillstoreid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillsysdate($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillclientname($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillsaveid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbildirectpayment($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE returnsellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM returnsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReturnsellbilldate($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillserial($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillclientid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldiscount($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldiscounttype($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotalbill($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillaftertotalbill($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilltotalpayed($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillfinalbill($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillstoreid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillsysdate($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM returnsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillclientname($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillsaveid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbildirectpayment($value) {
        $sql = 'DELETE FROM returnsellbill WHERE returnsellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM returnsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReturnsellbillMySql
     */
    protected function readRow($row) {
        $returnsellbill = new Returnsellbill();

        $returnsellbill->returnsellbillid = isset($row['returnsellbillid']) ? $row['returnsellbillid'] : '';
        $returnsellbill->returnsellbilldate = isset($row['returnsellbilldate']) ? $row['returnsellbilldate'] : '';
        $returnsellbill->returnsellbillserial = isset($row['returnsellbillserial']) ? $row['returnsellbillserial'] : '';
        $returnsellbill->returnsellbillclientid = isset($row['returnsellbillclientid']) ? $row['returnsellbillclientid'] : '';
        $returnsellbill->returnsellbilltotaldeptbefor = isset($row['returnsellbilltotaldeptbefor']) ? $row['returnsellbilltotaldeptbefor'] : '';
        $returnsellbill->returnsellbilltotaldeptafter = isset($row['returnsellbilltotaldeptafter']) ? $row['returnsellbilltotaldeptafter'] : '';
        $returnsellbill->returnsellbilldiscount = isset($row['returnsellbilldiscount']) ? $row['returnsellbilldiscount'] : '';
        $returnsellbill->returnsellbilldiscounttype = isset($row['returnsellbilldiscounttype']) ? $row['returnsellbilldiscounttype'] : '';
        $returnsellbill->returnsellbilltotalbill = isset($row['returnsellbilltotalbill']) ? $row['returnsellbilltotalbill'] : '';
        $returnsellbill->returnsellbillaftertotalbill = isset($row['returnsellbillaftertotalbill']) ? $row['returnsellbillaftertotalbill'] : '';
        $returnsellbill->returnsellbilltotalpayed = isset($row['returnsellbilltotalpayed']) ? $row['returnsellbilltotalpayed'] : '';
        $returnsellbill->returnsellbillfinalbill = isset($row['returnsellbillfinalbill']) ? $row['returnsellbillfinalbill'] : '';
        $returnsellbill->returnsellbillstoreid = isset($row['returnsellbillstoreid']) ? $row['returnsellbillstoreid'] : '';
        $returnsellbill->returnsellbillsysdate = isset($row['returnsellbillsysdate']) ? $row['returnsellbillsysdate'] : '';
        $returnsellbill->comment = isset($row['comment']) ? $row['comment'] : '';
        $returnsellbill->userid = isset($row['userid']) ? $row['userid'] : '';
        $returnsellbill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $returnsellbill->returnsellbillclientname = isset($row['returnsellbillclientname']) ? $row['returnsellbillclientname'] : '';
        $returnsellbill->returnsellbillsaveid = isset($row['returnsellbillsaveid']) ? $row['returnsellbillsaveid'] : '';
        $returnsellbill->returnsellbildirectpayment = isset($row['returnsellbildirectpayment']) ? $row['returnsellbildirectpayment'] : '';
        $returnsellbill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $returnsellbill->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $returnsellbill->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $returnsellbill->returnsellQuantity = isset($row['returnsellQuantity']) ? $row['returnsellQuantity'] : '';

        $returnsellbill->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $returnsellbill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $returnsellbill->tax = isset($row['tax']) ? $row['tax'] : '';
        $returnsellbill->carnumber = isset($row['carnumber']) ? $row['carnumber'] : '';
        $returnsellbill->cartype = isset($row['cartype']) ? $row['cartype'] : '';
        $returnsellbill->carchase = isset($row['carchase']) ? $row['carchase'] : '';
        $returnsellbill->carmotor = isset($row['carmotor']) ? $row['carmotor'] : '';
        $returnsellbill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';


        //required
        $returnsellbill->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $returnsellbill->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $returnsellbill->savename = isset($row['savename']) ? $row['savename'] : '';
        $returnsellbill->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $returnsellbill->useremployeename = isset($row['useremployeename']) ? $row['useremployeename'] : '';
        $returnsellbill->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $returnsellbill->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $returnsellbill->returnsellbilldetailquantity = isset($row['returnsellbilldetailquantity']) ? $row['returnsellbilldetailquantity'] : '';
        $returnsellbill->returnsellbilldetailprice = isset($row['returnsellbilldetailprice']) ? $row['returnsellbilldetailprice'] : '';
        $returnsellbill->allGenTotalReturn = isset($row['allGenTotalReturn']) ? $row['allGenTotalReturn'] : '';
        $returnsellbill->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';
        $returnsellbill->newSellbillidAfterEdit = isset($row['newSellbillidAfterEdit']) ? $row['newSellbillidAfterEdit'] : '';

        // m7md
        $returnsellbill->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $returnsellbill->sumTotalbill = isset($row['sumTotalbill']) ? $row['sumTotalbill'] : '';
        $returnsellbill->sumDiscount = isset($row['sumDiscount']) ? $row['sumDiscount'] : '';
        $returnsellbill->productid = isset($row['productid']) ? $row['productid'] : '';
        $returnsellbill->productName = isset($row['productName']) ? $row['productName'] : '';
        $returnsellbill->username = isset($row['username']) ? $row['username'] : '';
        $returnsellbill->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $returnsellbill->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $returnsellbill->countreturnsellbill = isset($row['countreturnsellbill']) ? $row['countreturnsellbill'] : '';


        $returnsellbill->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $returnsellbill->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';

        $returnsellbill->billReservation = isset($row['billReservation']) ? $row['billReservation'] : '';
        $returnsellbill->billReservationDate = isset($row['billReservationDate']) ? $row['billReservationDate'] : '';

        $returnsellbill->visaAccountId = isset($row['visaAccountId']) ? $row['visaAccountId'] : '';
        $returnsellbill->cashPayed = isset($row['cashPayed']) ? $row['cashPayed'] : '';
        $returnsellbill->visaPayed = isset($row['visaPayed']) ? $row['visaPayed'] : '';
        $returnsellbill->isBankAccountTransfer = isset($row['isBankAccountTransfer']) ? $row['isBankAccountTransfer'] : '';
        $returnsellbill->extraDiscountPer = isset($row['extraDiscountPer']) ? $row['extraDiscountPer'] : '';
        $returnsellbill->extraDiscountVal = isset($row['extraDiscountVal']) ? $row['extraDiscountVal'] : '';
        $returnsellbill->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $returnsellbill->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $returnsellbill->autoSaveFlag = isset($row['autoSaveFlag']) ? $row['autoSaveFlag'] : '';
        $returnsellbill->obgyBillType = isset($row['obgyBillType']) ? $row['obgyBillType'] : '';
        $returnsellbill->billoperationid = isset($row['billoperationid']) ? $row['billoperationid'] : '';
        $returnsellbill->obygyVisitId = isset($row['obygyVisitId']) ? $row['obygyVisitId'] : '';

        $returnsellbill->reviewType = isset($row['reviewType']) ? $row['reviewType'] : '';
        $returnsellbill->lastReviewType = isset($row['lastReviewType']) ? $row['lastReviewType'] : '';
        $returnsellbill->lastReviewUser = isset($row['lastReviewUser']) ? $row['lastReviewUser'] : '';
        $returnsellbill->lastReviewDateTime = isset($row['lastReviewDateTime']) ? $row['lastReviewDateTime'] : '';
        $returnsellbill->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $returnsellbill->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';
        $returnsellbill->awardrate = isset($row['awardrate']) ? $row['awardrate'] : '';
        $returnsellbill->sellbillno = isset($row['sellbillno']) ? $row['sellbillno'] : '';
        $returnsellbill->returnsellbilltypeclientid = isset($row['returnsellbilltypeclientid']) ? $row['returnsellbilltypeclientid'] : '';


        return $returnsellbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReturnsellbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>