<?php

/**
 * Class that operate on table 'religions'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-30 11:47
 */
class ReligionsMySqlDAO implements ReligionsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReligionsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM religions WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM religions';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM religions ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param religion primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM religions WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReligionsMySql religion
     */
    public function insert($religion) {
        $sql = 'INSERT INTO religions (name) VALUES (?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($religion->name);

        $id = $this->executeInsert($sqlQuery);
        $religion->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReligionsMySql religion
     */
    public function update($religion) {
        $sql = 'UPDATE religions SET name = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setString2($religion->name);

        $sqlQuery->setNumber($religion->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM religions';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM religions WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM religions WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReligionsMySql
     */
    protected function readRow($row) {
        $religion = new Religion();

        $religion->id = isset($row['id']) ? $row['id'] : '';
        $religion->name = isset($row['name']) ? $row['name'] : '';

        return $religion;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReligionsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>