<?php

/**
 * Class that operate on table 'productionout'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:14
 */
class ProductionoutMySqlDAO implements ProductionoutDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionoutMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionout WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionout';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionout ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionout primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionout WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionoutMySql productionout
     */
    public function insert($productionout) {
        $sql = 'INSERT INTO productionout (outStore, inStore, supplier, productid, sizeid, colorid, outQuantity, outUnitCost, outAllCost, comment, userid, sysDate, del,outAllCostTot) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionout->outStore);
        $sqlQuery->setNumber($productionout->inStore);
        $sqlQuery->setNumber($productionout->supplier);
        $sqlQuery->setNumber($productionout->productid);
        $sqlQuery->setNumber($productionout->sizeid);
        $sqlQuery->setNumber($productionout->colorid);
        $sqlQuery->set($productionout->outQuantity);
        $sqlQuery->set($productionout->outUnitCost);
        $sqlQuery->set($productionout->outAllCost);
        $sqlQuery->set($productionout->comment);
        $sqlQuery->setNumber($productionout->userid);
        $sqlQuery->set($productionout->sysDate);
        $sqlQuery->setNumber($productionout->del);
        $sqlQuery->setNumber($productionout->outAllCostTot);

        $id = $this->executeInsert($sqlQuery);
        $productionout->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionoutMySql productionout
     */
    public function update($productionout) {
        $sql = 'UPDATE productionout SET outStore = ?, inStore = ?, supplier = ?, productid = ?, sizeid = ?, colorid = ?, outQuantity = ?, outUnitCost = ?, outAllCost = ?, comment = ?, userid = ?, sysDate = ?, del = ?,outAllCostTot=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionout->outStore);
        $sqlQuery->setNumber($productionout->inStore);
        $sqlQuery->setNumber($productionout->supplier);
        $sqlQuery->setNumber($productionout->productid);
        $sqlQuery->setNumber($productionout->sizeid);
        $sqlQuery->setNumber($productionout->colorid);
        $sqlQuery->set($productionout->outQuantity);
        $sqlQuery->set($productionout->outUnitCost);
        $sqlQuery->set($productionout->outAllCost);
        $sqlQuery->set($productionout->comment);
        $sqlQuery->setNumber($productionout->userid);
        $sqlQuery->set($productionout->sysDate);
        $sqlQuery->setNumber($productionout->del);
        $sqlQuery->setNumber($productionout->outAllCostTot);

        $sqlQuery->setNumber($productionout->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionout';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOutStore($value) {
        $sql = 'SELECT * FROM productionout WHERE outStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInStore($value) {
        $sql = 'SELECT * FROM productionout WHERE inStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplier($value) {
        $sql = 'SELECT * FROM productionout WHERE supplier = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionout WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM productionout WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM productionout WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOutQuantity($value) {
        $sql = 'SELECT * FROM productionout WHERE outQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOutUnitCost($value) {
        $sql = 'SELECT * FROM productionout WHERE outUnitCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOutAllCost($value) {
        $sql = 'SELECT * FROM productionout WHERE outAllCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM productionout WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM productionout WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM productionout WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM productionout WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOutStore($value) {
        $sql = 'DELETE FROM productionout WHERE outStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInStore($value) {
        $sql = 'DELETE FROM productionout WHERE inStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplier($value) {
        $sql = 'DELETE FROM productionout WHERE supplier = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionout WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM productionout WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM productionout WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOutQuantity($value) {
        $sql = 'DELETE FROM productionout WHERE outQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOutUnitCost($value) {
        $sql = 'DELETE FROM productionout WHERE outUnitCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOutAllCost($value) {
        $sql = 'DELETE FROM productionout WHERE outAllCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM productionout WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM productionout WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM productionout WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM productionout WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionoutMySql
     */
    protected function readRow($row) {
        $productionout = new Productionout();

        $productionout->id = $row['id'];
        $productionout->outStore = $row['outStore'];
        $productionout->inStore = $row['inStore'];
        $productionout->supplier = $row['supplier'];
        $productionout->productid = $row['productid'];
        $productionout->sizeid = $row['sizeid'];
        $productionout->colorid = $row['colorid'];
        $productionout->outQuantity = $row['outQuantity'];
        $productionout->outUnitCost = $row['outUnitCost'];
        $productionout->outAllCost = $row['outAllCost'];
        $productionout->comment = $row['comment'];
        $productionout->userid = $row['userid'];
        $productionout->sysDate = $row['sysDate'];
        $productionout->del = $row['del'];
        $productionout->outAllCostTot = $row['outAllCostTot'];

        //
        $productionout->productName = $row['productName'];
        $productionout->productCatName = $row['productCatName'];
        $productionout->sizeName = $row['sizeName'];
        $productionout->colorName = $row['colorName'];
        $productionout->suppliername = $row['suppliername'];
        $productionout->storeNameOut = $row['storeNameOut'];
        $productionout->storeNameIn = $row['storeNameIn'];
        $productionout->dailyentryid = $row['dailyentryid'];

        return $productionout;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionoutMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>