<?php

/**
 * Class that operate on table 'productionexecutionproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:58
 */
class ProductionexecutionproductMySqlDAO implements ProductionexecutionproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionexecutionproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionexecutionproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionexecutionproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionexecutionproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionexecutionproductMySql productionexecutionproduct
     */
    public function insert($productionexecutionproduct) {
        $sql = 'INSERT INTO productionexecutionproduct (executionid, productid, unitid, quantity, actualquantity, cost, actualcost,buyPricesHistoryBookIdQuantity,sizeid,colorid) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionproduct->executionid);
        $sqlQuery->setNumber($productionexecutionproduct->productid);
        $sqlQuery->setNumber($productionexecutionproduct->unitid);
        $sqlQuery->setNumber($productionexecutionproduct->quantity);
        $sqlQuery->setNumber($productionexecutionproduct->actualquantity);
        $sqlQuery->set($productionexecutionproduct->cost);
        $sqlQuery->set($productionexecutionproduct->actualcost);
        $sqlQuery->set($productionexecutionproduct->buyPricesHistoryBookIdQuantity);
        $sqlQuery->setNumber((int) $productionexecutionproduct->sizeid);
        $sqlQuery->setNumber((int) $productionexecutionproduct->colorid);

        $id = $this->executeInsert($sqlQuery);
        $productionexecutionproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionexecutionproductMySql productionexecutionproduct
     */
    public function update($productionexecutionproduct) {
        $sql = 'UPDATE productionexecutionproduct SET executionid = ?, productid = ?, unitid = ?, quantity = ?, actualquantity = ?, cost = ?, actualcost = ?,buyPricesHistoryBookIdQuantity=?,sizeid=?,colorid=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionexecutionproduct->executionid);
        $sqlQuery->setNumber($productionexecutionproduct->productid);
        $sqlQuery->setNumber($productionexecutionproduct->unitid);
        $sqlQuery->setNumber($productionexecutionproduct->quantity);
        $sqlQuery->setNumber($productionexecutionproduct->actualquantity);
        $sqlQuery->set($productionexecutionproduct->cost);
        $sqlQuery->set($productionexecutionproduct->actualcost);
        $sqlQuery->set($productionexecutionproduct->buyPricesHistoryBookIdQuantity);
        $sqlQuery->setNumber((int) $productionexecutionproduct->sizeid);
        $sqlQuery->setNumber((int) $productionexecutionproduct->colorid);

        $sqlQuery->setNumber($productionexecutionproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionexecutionproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByExecutionid($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE executionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByActualquantity($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE actualquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCost($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByActualcost($value) {
        $sql = 'SELECT * FROM productionexecutionproduct WHERE actualcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByExecutionid($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE executionid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByActualquantity($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE actualquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCost($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByActualcost($value) {
        $sql = 'DELETE FROM productionexecutionproduct WHERE actualcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionexecutionproductMySql
     */
    protected function readRow($row) {
        $productionexecutionproduct = new Productionexecutionproduct();

        $productionexecutionproduct->id = $row['id'];
        $productionexecutionproduct->executionid = $row['executionid'];
        $productionexecutionproduct->productid = $row['productid'];
        $productionexecutionproduct->unitid = $row['unitid'];
        $productionexecutionproduct->quantity = isset($row['quantity']) ? (float) $row['quantity'] : '';
        $productionexecutionproduct->actualquantity = isset($row['actualquantity']) ? (float) $row['actualquantity'] : '';
        $productionexecutionproduct->cost = $row['cost'];
        $productionexecutionproduct->actualcost = $row['actualcost'];
        $productionexecutionproduct->buyPricesHistoryBookIdQuantity = $row['buyPricesHistoryBookIdQuantity'];
        $productionexecutionproduct->sizeid = $row['sizeid'];
        $productionexecutionproduct->colorid = $row['colorid'];


        $productionexecutionproduct->productName = $row['productName'];
        $productionexecutionproduct->unitName = $row['unitName'];
        $productionexecutionproduct->productBuyPrice = $row['productBuyPrice'];
        $productionexecutionproduct->sizeName = $row['sizeName'];
        $productionexecutionproduct->colorName = $row['colorName'];

        return $productionexecutionproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionexecutionproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>