<?php

/**
 * Class that operate on table 'productionexecution'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:58
 */
class ProductionexecutionMySqlDAO implements ProductionexecutionDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionexecutionMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionexecution WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionexecution';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionexecution ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionexecution primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionexecution WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionexecutionMySql productionexecution
     */
    public function insert($productionexecution) {
        $sql = 'INSERT INTO productionexecution (orderId, title, orderdate, taskid, productid, num, outstoreid, wastestoreid, rentcost, othercost, executioncost, sysdate, executed,comment,sizeid,colorid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber((int) $productionexecution->orderId);
        $sqlQuery->set($productionexecution->title);
        $sqlQuery->set($productionexecution->orderdate);
        $sqlQuery->setNumber($productionexecution->taskid);
        $sqlQuery->setNumber($productionexecution->productid);
        $sqlQuery->setNumber($productionexecution->num);
        $sqlQuery->setNumber($productionexecution->outstoreid);
        $sqlQuery->setNumber($productionexecution->wastestoreid);
        $sqlQuery->set($productionexecution->rentcost);
        $sqlQuery->set($productionexecution->othercost);
        $sqlQuery->set($productionexecution->executioncost);
        $sqlQuery->set($productionexecution->sysdate);
        $sqlQuery->setNumber($productionexecution->executed);
        $sqlQuery->set($productionexecution->comment);
        $sqlQuery->setNumber((int) $productionexecution->sizeid);
        $sqlQuery->setNumber((int) $productionexecution->colorid);

        $id = $this->executeInsert($sqlQuery);
        $productionexecution->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionexecutionMySql productionexecution
     */
    public function update($productionexecution) {
        $sql = 'UPDATE productionexecution SET orderId = ?, title = ?, orderdate = ?, taskid = ?, productid = ?, num = ?, outstoreid = ?, wastestoreid = ?, rentcost = ?, othercost = ?, executioncost = ?, sysdate = ?,executed = ?,comment = ?,sizeid=?,colorid=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber((int) $productionexecution->orderId);
        $sqlQuery->set($productionexecution->title);
        $sqlQuery->set($productionexecution->orderdate);
        $sqlQuery->setNumber($productionexecution->taskid);
        $sqlQuery->setNumber($productionexecution->productid);
        $sqlQuery->setNumber($productionexecution->num);
        $sqlQuery->setNumber($productionexecution->outstoreid);
        $sqlQuery->setNumber($productionexecution->wastestoreid);
        $sqlQuery->set($productionexecution->rentcost);
        $sqlQuery->set($productionexecution->othercost);
        $sqlQuery->set($productionexecution->executioncost);
        $sqlQuery->set($productionexecution->sysdate);
        $sqlQuery->setNumber($productionexecution->executed);
        $sqlQuery->set($productionexecution->comment);
        $sqlQuery->setNumber((int) $productionexecution->sizeid);
        $sqlQuery->setNumber((int) $productionexecution->colorid);

        $sqlQuery->setNumber($productionexecution->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionexecution';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderId($value) {
        $sql = 'SELECT * FROM productionexecution WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTitle($value) {
        $sql = 'SELECT * FROM productionexecution WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderdate($value) {
        $sql = 'SELECT * FROM productionexecution WHERE orderdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTaskid($value) {
        $sql = 'SELECT * FROM productionexecution WHERE taskid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionexecution WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNum($value) {
        $sql = 'SELECT * FROM productionexecution WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOutstoreid($value) {
        $sql = 'SELECT * FROM productionexecution WHERE outstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWastestoreid($value) {
        $sql = 'SELECT * FROM productionexecution WHERE wastestoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRentcost($value) {
        $sql = 'SELECT * FROM productionexecution WHERE rentcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOthercost($value) {
        $sql = 'SELECT * FROM productionexecution WHERE othercost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExecutioncost($value) {
        $sql = 'SELECT * FROM productionexecution WHERE executioncost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM productionexecution WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderId($value) {
        $sql = 'DELETE FROM productionexecution WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTitle($value) {
        $sql = 'DELETE FROM productionexecution WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderdate($value) {
        $sql = 'DELETE FROM productionexecution WHERE orderdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTaskid($value) {
        $sql = 'DELETE FROM productionexecution WHERE taskid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionexecution WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNum($value) {
        $sql = 'DELETE FROM productionexecution WHERE num = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOutstoreid($value) {
        $sql = 'DELETE FROM productionexecution WHERE outstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWastestoreid($value) {
        $sql = 'DELETE FROM productionexecution WHERE wastestoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRentcost($value) {
        $sql = 'DELETE FROM productionexecution WHERE rentcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOthercost($value) {
        $sql = 'DELETE FROM productionexecution WHERE othercost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExecutioncost($value) {
        $sql = 'DELETE FROM productionexecution WHERE executioncost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM productionexecution WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionexecutionMySql
     */
    protected function readRow($row) {
        $productionexecution = new Productionexecution();

        $productionexecution->id = $row['id'];
        $productionexecution->orderId = $row['orderId'];
        $productionexecution->title = $row['title'];
        $productionexecution->orderdate = $row['orderdate'];
        $productionexecution->taskid = $row['taskid'];
        $productionexecution->productid = $row['productid'];
        $productionexecution->num = isset($row['num']) ? (float) $row['num'] : '';
        $productionexecution->outstoreid = $row['outstoreid'];
        $productionexecution->wastestoreid = $row['wastestoreid'];
        $productionexecution->rentcost = $row['rentcost'];
        $productionexecution->othercost = $row['othercost'];
        $productionexecution->executioncost = $row['executioncost'];
        $productionexecution->sysdate = $row['sysdate'];
        $productionexecution->executed = $row['executed'];
        $productionexecution->comment = $row['comment'];
        $productionexecution->sizeid = $row['sizeid'];
        $productionexecution->colorid = $row['colorid'];

        $productionexecution->productName = $row['productName'];
        $productionexecution->sizeName = $row['sizeName'];
        $productionexecution->colorName = $row['colorName'];
        $productionexecution->dailyentryid = $row['dailyentryid'];

        return $productionexecution;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionexecutionMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>