<?php

/**
 * Class that operate on table 'paymentnetworks'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
class PaymentnetworksMySqlDAO implements PaymentnetworksDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PaymentnetworksMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM paymentnetworks WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM paymentnetworks';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM paymentnetworks ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param paymentnetwork primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM paymentnetworks WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PaymentnetworksMySql paymentnetwork
     */
    public function insert($paymentnetwork) {
        $sql = 'INSERT INTO paymentnetworks (name, deleted , discountpercent ,nameen) VALUES (? , ? , ? , ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($paymentnetwork->name);
        $sqlQuery->setNumber($paymentnetwork->deleted);
        $sqlQuery->set($paymentnetwork->discountpercent);
        $sqlQuery->set($paymentnetwork->nameen);

        $id = $this->executeInsert($sqlQuery);
        $paymentnetwork->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PaymentnetworksMySql paymentnetwork
     */
    public function update($paymentnetwork) {
        $sql = 'UPDATE paymentnetworks SET name = ?, deleted = ? ,discountpercent = ? , nameen = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($paymentnetwork->name);
        $sqlQuery->setNumber($paymentnetwork->deleted);
        $sqlQuery->set($paymentnetwork->discountpercent);
        $sqlQuery->set($paymentnetwork->nameen);

        $sqlQuery->setNumber($paymentnetwork->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM paymentnetworks';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM paymentnetworks WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM paymentnetworks WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM paymentnetworks WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM paymentnetworks WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PaymentnetworksMySql
     */
    protected function readRow($row) {
        $paymentnetwork = new Paymentnetwork();

        $paymentnetwork->id = isset($row['id']) ? $row['id'] : '';
        $paymentnetwork->name = isset($row['name']) ? $row['name'] : '';
        $paymentnetwork->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $paymentnetwork->discountpercent = isset($row['discountpercent']) ? $row['discountpercent'] : '';
        $paymentnetwork->nameen = isset($row['nameen']) ? $row['nameen'] : '';

        return $paymentnetwork;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PaymentnetworksMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>