<?php

/**
 * Class that operate on table 'onlinetemporderclient'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-12-22 14:15
 */
class OnlinetemporderclientMySqlDAO implements OnlinetemporderclientDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OnlinetemporderclientMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM onlinetemporderclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM onlinetemporderclient ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param onlinetemporderclient primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OnlinetemporderclientMySql onlinetemporderclient
     */
    public function insert($onlinetemporderclient) {
        $sql = 'INSERT INTO onlinetemporderclient (erpid, customer_id, orderid, clientname, clientcode, clientmobile, clientdebt, clientaddress, clientareaid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporderclient->erpid);
        $sqlQuery->setNumber($onlinetemporderclient->customer_id);
        $sqlQuery->setNumber($onlinetemporderclient->orderid);
        $sqlQuery->set($onlinetemporderclient->clientname);
        $sqlQuery->set($onlinetemporderclient->clientcode);
        $sqlQuery->set($onlinetemporderclient->clientmobile);
        $sqlQuery->set($onlinetemporderclient->clientdebt);
        $sqlQuery->set($onlinetemporderclient->clientaddress);
        $sqlQuery->setNumber($onlinetemporderclient->clientareaid);

        $id = $this->executeInsert($sqlQuery);
        $onlinetemporderclient->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OnlinetemporderclientMySql onlinetemporderclient
     */
    public function update($onlinetemporderclient) {
        $sql = 'UPDATE onlinetemporderclient SET erpid = ?, customer_id = ?, orderid = ?, clientname = ?, clientcode = ?, clientmobile = ?, clientdebt = ?, clientaddress = ?, clientareaid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporderclient->erpid);
        $sqlQuery->setNumber($onlinetemporderclient->customer_id);
        $sqlQuery->setNumber($onlinetemporderclient->orderid);
        $sqlQuery->set($onlinetemporderclient->clientname);
        $sqlQuery->set($onlinetemporderclient->clientcode);
        $sqlQuery->set($onlinetemporderclient->clientmobile);
        $sqlQuery->set($onlinetemporderclient->clientdebt);
        $sqlQuery->set($onlinetemporderclient->clientaddress);
        $sqlQuery->setNumber($onlinetemporderclient->clientareaid);

        $sqlQuery->setNumber($onlinetemporderclient->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM onlinetemporderclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByErpid($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE erpid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderid($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE orderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    public function queryByClientname($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientcode($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientmobile($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebt($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientaddress($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientareaid($value) {
        $sql = 'SELECT * FROM onlinetemporderclient WHERE clientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByErpid($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE erpid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderid($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE orderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientname($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientcode($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientmobile($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebt($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientaddress($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientareaid($value) {
        $sql = 'DELETE FROM onlinetemporderclient WHERE clientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OnlinetemporderclientMySql
     */
    protected function readRow($row) {
        $onlinetemporderclient = new Onlinetemporderclient();

        $onlinetemporderclient->id = $row['id'];
        $onlinetemporderclient->erpid = $row['erpid'];
        $onlinetemporderclient->customer_id = $row['customer_id'];
        $onlinetemporderclient->orderid = $row['orderid'];
        $onlinetemporderclient->clientname = $row['clientname'];
        $onlinetemporderclient->clientcode = $row['clientcode'];
        $onlinetemporderclient->clientmobile = $row['clientmobile'];
        $onlinetemporderclient->clientdebt = $row['clientdebt'];
        $onlinetemporderclient->clientaddress = $row['clientaddress'];
        $onlinetemporderclient->clientareaid = $row['clientareaid'];

        return $onlinetemporderclient;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OnlinetemporderclientMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>