<?php

/**
 * Class that operate on table 'onlinestoresetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-27 14:33
 */
class OnlinestoresettingMySqlDAO implements OnlinestoresettingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OnlinestoresettingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM onlinestoresetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM onlinestoresetting ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param onlinestoresetting primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM onlinestoresetting WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OnlinestoresettingMySql onlinestoresetting
     */
    public function insert($onlinestoresetting) {
        $sql = 'INSERT INTO onlinestoresetting (url, availableStores, onlinestoreid, onlineclientareaid, updatetype, catprohour, catprominute, proquantityhour, proquantityminute, clientshour, clientsminute, ordershour, ordersminute, clientdebtchangeStartId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($onlinestoresetting->url);
        $sqlQuery->set($onlinestoresetting->availableStores);
        $sqlQuery->setNumber($onlinestoresetting->onlinestoreid);
        $sqlQuery->setNumber($onlinestoresetting->onlineclientareaid);
        $sqlQuery->setNumber($onlinestoresetting->updatetype);
        $sqlQuery->set($onlinestoresetting->catprohour);
        $sqlQuery->set($onlinestoresetting->catprominute);
        $sqlQuery->set($onlinestoresetting->proquantityhour);
        $sqlQuery->set($onlinestoresetting->proquantityminute);
        $sqlQuery->set($onlinestoresetting->clientshour);
        $sqlQuery->set($onlinestoresetting->clientsminute);
        $sqlQuery->set($onlinestoresetting->ordershour);
        $sqlQuery->set($onlinestoresetting->ordersminute);
        $sqlQuery->setNumber($onlinestoresetting->clientdebtchangeStartId);

        $id = $this->executeInsert($sqlQuery);
        $onlinestoresetting->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OnlinestoresettingMySql onlinestoresetting
     */
    public function update($onlinestoresetting) {
        $sql = 'UPDATE onlinestoresetting SET url = ?, availableStores = ?, onlinestoreid = ?, onlineclientareaid = ?, updatetype = ?, catprohour = ?, catprominute = ?, proquantityhour = ?, proquantityminute = ?, clientshour = ?, clientsminute = ?, ordershour = ?, ordersminute = ?, clientdebtchangeStartId = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($onlinestoresetting->url);
        $sqlQuery->set($onlinestoresetting->availableStores);
        $sqlQuery->setNumber($onlinestoresetting->onlinestoreid);
        $sqlQuery->setNumber($onlinestoresetting->onlineclientareaid);
        $sqlQuery->setNumber($onlinestoresetting->updatetype);
        $sqlQuery->set($onlinestoresetting->catprohour);
        $sqlQuery->set($onlinestoresetting->catprominute);
        $sqlQuery->set($onlinestoresetting->proquantityhour);
        $sqlQuery->set($onlinestoresetting->proquantityminute);
        $sqlQuery->set($onlinestoresetting->clientshour);
        $sqlQuery->set($onlinestoresetting->clientsminute);
        $sqlQuery->set($onlinestoresetting->ordershour);
        $sqlQuery->set($onlinestoresetting->ordersminute);
        $sqlQuery->setNumber($onlinestoresetting->clientdebtchangeStartId);

        $sqlQuery->setNumber($onlinestoresetting->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM onlinestoresetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUrl($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE url = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAvailableStores($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE availableStores = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOnlinestoreid($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE onlinestoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOnlineclientareaid($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE onlineclientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUpdatetype($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE updatetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCatprohour($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE catprohour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCatprominute($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE catprominute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProquantityhour($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE proquantityhour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProquantityminute($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE proquantityminute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientshour($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE clientshour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientsminute($value) {
        $sql = 'SELECT * FROM onlinestoresetting WHERE clientsminute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUrl($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE url = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAvailableStores($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE availableStores = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOnlinestoreid($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE onlinestoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOnlineclientareaid($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE onlineclientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUpdatetype($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE updatetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCatprohour($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE catprohour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCatprominute($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE catprominute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProquantityhour($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE proquantityhour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProquantityminute($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE proquantityminute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientshour($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE clientshour = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientsminute($value) {
        $sql = 'DELETE FROM onlinestoresetting WHERE clientsminute = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OnlinestoresettingMySql
     */
    protected function readRow($row) {
        $onlinestoresetting = new Onlinestoresetting();

        $onlinestoresetting->id = $row['id'];
        $onlinestoresetting->url = $row['url'];
        $onlinestoresetting->availableStores = $row['availableStores'];
        $onlinestoresetting->onlinestoreid = $row['onlinestoreid'];
        $onlinestoresetting->onlineclientareaid = $row['onlineclientareaid'];
        $onlinestoresetting->updatetype = $row['updatetype'];
        $onlinestoresetting->catprohour = $row['catprohour'];
        $onlinestoresetting->catprominute = $row['catprominute'];
        $onlinestoresetting->proquantityhour = $row['proquantityhour'];
        $onlinestoresetting->proquantityminute = $row['proquantityminute'];
        $onlinestoresetting->clientshour = $row['clientshour'];
        $onlinestoresetting->clientsminute = $row['clientsminute'];
        $onlinestoresetting->ordershour = $row['ordershour'];
        $onlinestoresetting->ordersminute = $row['ordersminute'];
        $onlinestoresetting->clientdebtchangeStartId = $row['clientdebtchangeStartId'];
        return $onlinestoresetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OnlinestoresettingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>