<?php

/**
 * Class that operate on table 'offerpricebillprop'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-13 15:29
 */
class OfferpricebillpropMySqlDAO implements OfferpricebillpropDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OfferpricebillpropMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM offerpricebillprop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM offerpricebillprop';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM offerpricebillprop ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param offerpricebillprop primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM offerpricebillprop WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OfferpricebillpropMySql offerpricebillprop
     */
    public function insert($offerpricebillprop) {
        $sql = 'INSERT INTO offerpricebillprop (clientid, clientname, totalprice,realtotalprice,sysdate,serialno) VALUES (?,?,?,?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($offerpricebillprop->clientid);
        $sqlQuery->set($offerpricebillprop->clientname);
        $sqlQuery->set($offerpricebillprop->totalprice);
        $sqlQuery->set($offerpricebillprop->realtotalprice);
        $sqlQuery->set($offerpricebillprop->sysdate);
        $sqlQuery->set($offerpricebillprop->serialno);

        $id = $this->executeInsert($sqlQuery);
        $offerpricebillprop->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OfferpricebillpropMySql offerpricebillprop
     */
    public function update($offerpricebillprop) {
        $sql = 'UPDATE offerpricebillprop SET clientid = ?, clientname = ?, totalprice = ?, realtotalprice = ?,sysdate = ?,serialno= ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($offerpricebillprop->clientid);
        $sqlQuery->set($offerpricebillprop->clientname);
        $sqlQuery->set($offerpricebillprop->totalprice);
        $sqlQuery->set($offerpricebillprop->realtotalprice);
        $sqlQuery->set($offerpricebillprop->sysdate);
        $sqlQuery->set($offerpricebillprop->serialno);

        $sqlQuery->setNumber($offerpricebillprop->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM offerpricebillprop';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM offerpricebillprop WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientname($value) {
        $sql = 'SELECT * FROM offerpricebillprop WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalprice($value) {
        $sql = 'SELECT * FROM offerpricebillprop WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM offerpricebillprop WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientname($value) {
        $sql = 'DELETE FROM offerpricebillprop WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalprice($value) {
        $sql = 'DELETE FROM offerpricebillprop WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OfferpricebillpropMySql
     */
    protected function readRow($row) {
        $offerpricebillprop = new Offerpricebillprop();

        $offerpricebillprop->id = isset($row['id']) ? $row['id'] : '';
        $offerpricebillprop->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $offerpricebillprop->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $offerpricebillprop->totalprice = isset($row['totalprice']) ? $row['totalprice'] : '';
        $offerpricebillprop->realtotalprice = isset($row['realtotalprice']) ? $row['realtotalprice'] : '';
        $offerpricebillprop->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $offerpricebillprop->serialno = isset($row['serialno']) ? $row['serialno'] : '';

        return $offerpricebillprop;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OfferpricebillpropMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>