<?php

/**
 * Class that operate on table 'm_maintenancereceipt'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MMaintenancereceiptMySqlDAO implements MMaintenancereceiptDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MMaintenancereceiptMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE maintenanceReceiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_maintenancereceipt';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_maintenancereceipt ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mMaintenancereceipt primary key
     */
    public function delete($maintenanceReceiptId) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE maintenanceReceiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($maintenanceReceiptId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MMaintenancereceiptMySql mMaintenancereceipt
     */
    public function insert($mMaintenancereceipt) {
        $sql = 'INSERT INTO m_maintenancereceipt (receiptId, totalCost, type, userId, branchId, maintenanceReceiptDAte, del) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mMaintenancereceipt->receiptId);
        $sqlQuery->set($mMaintenancereceipt->totalCost);
        $sqlQuery->setNumber($mMaintenancereceipt->type);
        $sqlQuery->setNumber($mMaintenancereceipt->userId);
        $sqlQuery->setNumber($mMaintenancereceipt->branchId);
        $sqlQuery->set($mMaintenancereceipt->maintenanceReceiptDAte);
        $sqlQuery->setNumber($mMaintenancereceipt->del);

        $id = $this->executeInsert($sqlQuery);
        $mMaintenancereceipt->maintenanceReceiptId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MMaintenancereceiptMySql mMaintenancereceipt
     */
    public function update($mMaintenancereceipt) {
        $sql = 'UPDATE m_maintenancereceipt SET receiptId = ?, totalCost = ?, type = ?, userId = ?, branchId = ?, maintenanceReceiptDAte = ?, del = ? WHERE maintenanceReceiptId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mMaintenancereceipt->receiptId);
        $sqlQuery->set($mMaintenancereceipt->totalCost);
        $sqlQuery->setNumber($mMaintenancereceipt->type);
        $sqlQuery->setNumber($mMaintenancereceipt->userId);
        $sqlQuery->setNumber($mMaintenancereceipt->branchId);
        $sqlQuery->set($mMaintenancereceipt->maintenanceReceiptDAte);
        $sqlQuery->setNumber($mMaintenancereceipt->del);

        $sqlQuery->setNumber($mMaintenancereceipt->maintenanceReceiptId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_maintenancereceipt';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReceiptId($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE receiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalCost($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE totalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMaintenanceReceiptDAte($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE maintenanceReceiptDAte = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_maintenancereceipt WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReceiptId($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE receiptId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalCost($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE totalCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMaintenanceReceiptDAte($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE maintenanceReceiptDAte = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_maintenancereceipt WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MMaintenancereceiptMySql
     */
    protected function readRow($row) {
        $mMaintenancereceipt = new MMaintenancereceipt();

        $mMaintenancereceipt->maintenanceReceiptId = isset($row['maintenanceReceiptId']) ? $row['maintenanceReceiptId'] : '';
        $mMaintenancereceipt->receiptId = isset($row['receiptId']) ? $row['receiptId'] : '';
        $mMaintenancereceipt->totalCost = isset($row['totalCost']) ? $row['totalCost'] : '';
        $mMaintenancereceipt->type = isset($row['type']) ? $row['type'] : '';
        $mMaintenancereceipt->userId = isset($row['userId']) ? $row['userId'] : '';
        $mMaintenancereceipt->branchId = isset($row['userId']) ? $row['userId'] : '';
        $mMaintenancereceipt->maintenanceReceiptDAte = isset($row['maintenanceReceiptDAte']) ? $row['maintenanceReceiptDAte'] : '';
        $mMaintenancereceipt->del = isset($row['del']) ? $row['del'] : '';

        $mMaintenancereceipt->receiptserial = isset($row['receiptserial']) ? $row['receiptserial'] : '';

        return $mMaintenancereceipt;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MMaintenancereceiptMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>