<?php

/**
 * Class that operate on table 'm_initialmaintenancedetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MInitialmaintenancedetailMySqlDAO implements MInitialmaintenancedetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MInitialmaintenancedetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE initialMaintenanceDetailId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_initialmaintenancedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mInitialmaintenancedetail primary key
     */
    public function delete($initialMaintenanceDetailId) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE initialMaintenanceDetailId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($initialMaintenanceDetailId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MInitialmaintenancedetailMySql mInitialmaintenancedetail
     */
    public function insert($mInitialmaintenancedetail) {
        $sql = 'INSERT INTO m_initialmaintenancedetail (initialMaintenanceId, propertyId, propertyValue, userId, branchId, initialMaintenanceDetailDate, del) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mInitialmaintenancedetail->initialMaintenanceId);
        $sqlQuery->setNumber($mInitialmaintenancedetail->propertyId);
        $sqlQuery->set($mInitialmaintenancedetail->propertyValue);
        $sqlQuery->setNumber($mInitialmaintenancedetail->userId);
        $sqlQuery->setNumber($mInitialmaintenancedetail->branchId);
        $sqlQuery->set($mInitialmaintenancedetail->initialMaintenanceDetailDate);
        $sqlQuery->setNumber($mInitialmaintenancedetail->del);

        $id = $this->executeInsert($sqlQuery);
        $mInitialmaintenancedetail->initialMaintenanceDetailId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MInitialmaintenancedetailMySql mInitialmaintenancedetail
     */
    public function update($mInitialmaintenancedetail) {
        $sql = 'UPDATE m_initialmaintenancedetail SET initialMaintenanceId = ?, propertyId = ?, propertyValue = ?, userId = ?, branchId = ?, initialMaintenanceDetailDate = ?, del = ? WHERE initialMaintenanceDetailId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mInitialmaintenancedetail->initialMaintenanceId);
        $sqlQuery->setNumber($mInitialmaintenancedetail->propertyId);
        $sqlQuery->set($mInitialmaintenancedetail->propertyValue);
        $sqlQuery->setNumber($mInitialmaintenancedetail->userId);
        $sqlQuery->setNumber($mInitialmaintenancedetail->branchId);
        $sqlQuery->set($mInitialmaintenancedetail->initialMaintenanceDetailDate);
        $sqlQuery->setNumber($mInitialmaintenancedetail->del);

        $sqlQuery->setNumber($mInitialmaintenancedetail->initialMaintenanceDetailId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_initialmaintenancedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByInitialMaintenanceId($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE initialMaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyId($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE propertyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyValue($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE propertyValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitialMaintenanceDetailDate($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE initialMaintenanceDetailDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_initialmaintenancedetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByInitialMaintenanceId($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE initialMaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyId($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE propertyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyValue($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE propertyValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitialMaintenanceDetailDate($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE initialMaintenanceDetailDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_initialmaintenancedetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MInitialmaintenancedetailMySql
     */
    protected function readRow($row) {
        $mInitialmaintenancedetail = new MInitialmaintenancedetail();

        $mInitialmaintenancedetail->initialMaintenanceDetailId = isset($row['initialMaintenanceDetailId']) ? $row['initialMaintenanceDetailId'] : '';
        $mInitialmaintenancedetail->initialMaintenanceId = isset($row['initialMaintenanceId']) ? $row['initialMaintenanceId'] : '';
        $mInitialmaintenancedetail->propertyId = isset($row['propertyId']) ? $row['propertyId'] : '';
        $mInitialmaintenancedetail->propertyValue = isset($row['propertyValue']) ? $row['propertyValue'] : '';
        $mInitialmaintenancedetail->userId = isset($row['userId']) ? $row['userId'] : '';
        $mInitialmaintenancedetail->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mInitialmaintenancedetail->initialMaintenanceDetailDate = isset($row['initialMaintenanceDetailDate']) ? $row['initialMaintenanceDetailDate'] : '';
        $mInitialmaintenancedetail->del = isset($row['del']) ? $row['del'] : '';

        return $mInitialmaintenancedetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MInitialmaintenancedetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>