<?php

/**
 * Class that operate on table 'm_finishingpayed'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MFinishingpayedMySqlDAO implements MFinishingpayedDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MFinishingpayedMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE finishingPayedId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_finishingpayed';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_finishingpayed ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mFinishingpayed primary key
     */
    public function delete($finishingPayedId) {
        $sql = 'DELETE FROM m_finishingpayed WHERE finishingPayedId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($finishingPayedId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MFinishingpayedMySql mFinishingpayed
     */
    public function insert($mFinishingpayed) {
        $sql = 'INSERT INTO m_finishingpayed (clientId, payed, clientDebtChangeId, finishingType, finishingPayedDate, remain, userId, branchId, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mFinishingpayed->clientId);
        $sqlQuery->set($mFinishingpayed->payed);
        $sqlQuery->setNumber($mFinishingpayed->clientDebtChangeId);
        $sqlQuery->setNumber($mFinishingpayed->finishingType);
        $sqlQuery->set($mFinishingpayed->finishingPayedDate);
        $sqlQuery->set($mFinishingpayed->remain);
        $sqlQuery->setNumber($mFinishingpayed->userId);
        $sqlQuery->setNumber($mFinishingpayed->branchId);
        $sqlQuery->setNumber($mFinishingpayed->del);

        $id = $this->executeInsert($sqlQuery);
        $mFinishingpayed->finishingPayedId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MFinishingpayedMySql mFinishingpayed
     */
    public function update($mFinishingpayed) {
        $sql = 'UPDATE m_finishingpayed SET clientId = ?, payed = ?, clientDebtChangeId = ?, finishingType = ?, finishingPayedDate = ?, remain = ?, userId = ?, branchId = ?, del = ? WHERE finishingPayedId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mFinishingpayed->clientId);
        $sqlQuery->set($mFinishingpayed->payed);
        $sqlQuery->setNumber($mFinishingpayed->clientDebtChangeId);
        $sqlQuery->setNumber($mFinishingpayed->finishingType);
        $sqlQuery->set($mFinishingpayed->finishingPayedDate);
        $sqlQuery->set($mFinishingpayed->remain);
        $sqlQuery->setNumber($mFinishingpayed->userId);
        $sqlQuery->setNumber($mFinishingpayed->branchId);
        $sqlQuery->setNumber($mFinishingpayed->del);

        $sqlQuery->setNumber($mFinishingpayed->finishingPayedId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_finishingpayed';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientId($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayed($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientDebtChangeId($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE clientDebtChangeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinishingType($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE finishingType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinishingPayedDate($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE finishingPayedDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRemain($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE remain = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_finishingpayed WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientId($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE clientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayed($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientDebtChangeId($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE clientDebtChangeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinishingType($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE finishingType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinishingPayedDate($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE finishingPayedDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRemain($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE remain = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_finishingpayed WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MFinishingpayedMySql
     */
    protected function readRow($row) {
        $mFinishingpayed = new MFinishingpayed();

        $mFinishingpayed->finishingPayedId = isset($row['finishingPayedId']) ? $row['finishingPayedId'] : '';
        $mFinishingpayed->clientId = isset($row['clientId']) ? $row['clientId'] : '';
        $mFinishingpayed->payed = isset($row['payed']) ? $row['payed'] : '';
        $mFinishingpayed->clientDebtChangeId = isset($row['clientDebtChangeId']) ? $row['clientDebtChangeId'] : '';
        $mFinishingpayed->finishingType = isset($row['finishingType']) ? $row['finishingType'] : '';
        $mFinishingpayed->finishingPayedDate = isset($row['finishingPayedDate']) ? $row['finishingPayedDate'] : '';
        $mFinishingpayed->remain = isset($row['remain']) ? $row['remain'] : '';
        $mFinishingpayed->userId = isset($row['userId']) ? $row['userId'] : '';
        $mFinishingpayed->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mFinishingpayed->del = isset($row['del']) ? $row['del'] : '';

        return $mFinishingpayed;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MFinishingpayedMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>