<?php
/**
 * Class that operate on table 'languages'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-12-01 19:30
 */
class LanguagesMySqlDAO implements LanguagesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return LanguagesMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM languages WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM languages';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM languages ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param language primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM languages WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param LanguagesMySql language
 	 */
	public function insert($language){
		$sql = 'INSERT INTO languages (name, code, locale, status, is_default, lang_dir) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($language->name);
		$sqlQuery->set($language->code);
		$sqlQuery->set($language->locale);
		$sqlQuery->setNumber($language->status);
		$sqlQuery->set($language->isDefault);
		$sqlQuery->setNumber($language->langDir);

		$id = $this->executeInsert($sqlQuery);	
		$language->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param LanguagesMySql language
 	 */
	public function update($language){
		$sql = 'UPDATE languages SET name = ?, code = ?, locale = ?, status = ?, is_default = ?, lang_dir = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($language->name);
		$sqlQuery->set($language->code);
		$sqlQuery->set($language->locale);
		$sqlQuery->setNumber($language->status);
		$sqlQuery->set($language->isDefault);
		$sqlQuery->setNumber($language->langDir);

		$sqlQuery->setNumber($language->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM languages';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM languages WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCode($value){
		$sql = 'SELECT * FROM languages WHERE code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLocale($value){
		$sql = 'SELECT * FROM languages WHERE locale = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM languages WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIsDefault($value){
		$sql = 'SELECT * FROM languages WHERE is_default = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLangDir($value){
		$sql = 'SELECT * FROM languages WHERE lang_dir = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM languages WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCode($value){
		$sql = 'DELETE FROM languages WHERE code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLocale($value){
		$sql = 'DELETE FROM languages WHERE locale = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM languages WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIsDefault($value){
		$sql = 'DELETE FROM languages WHERE is_default = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLangDir($value){
		$sql = 'DELETE FROM languages WHERE lang_dir = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return LanguagesMySql 
	 */
	protected function readRow($row){
		$language = new Language();
		
		$language->id = $row['id'];
		$language->name = $row['name'];
		$language->code = $row['code'];
		$language->locale = $row['locale'];
		$language->status = $row['status'];
		$language->isDefault = $row['is_default'];
		$language->langDir = $row['lang_dir'];

		return $language;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return LanguagesMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>