<?php

/**
 * Class that operate on table 'kashf'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
class KashfMySqlDAO implements KashfDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return KashfMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM kashf WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM kashf';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM kashf ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param kashf primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM kashf WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param KashfMySql kashf
     */
    public function insert($kashf) {
        $sql = 'INSERT INTO kashf (kashfvalue, kashftype, customerid, doctorid, kashfdate, '
                . 'entered, paystatus , rondomtxt, branchid, offline, uploaddate,dailyentryid '
                . ',kasfhserial , discountkashf ,used , bill_id) VALUES (?,?,?,?,? ,? , ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($kashf->kashfvalue);
        $sqlQuery->set($kashf->kashftype);
        $sqlQuery->setNumber($kashf->customerid);
        $sqlQuery->setNumber($kashf->doctorid);
        $sqlQuery->set($kashf->kashfdate);
        $sqlQuery->setNumber($kashf->entered);
        $sqlQuery->setNumber($kashf->paystatus);

        $sqlQuery->set($kashf->rondomtxt);

        $sqlQuery->setNumber($kashf->branchid);
        $sqlQuery->setNumber($kashf->offline);

        $sqlQuery->set($kashf->uploaddate);
        $sqlQuery->setNumber($kashf->dailyentryid);
        $sqlQuery->setNumber($kashf->kasfhserial);
        $sqlQuery->setNumber($kashf->discountkashf);
        $sqlQuery->setNumber($kashf->used);
        $sqlQuery->setNumber($kashf->bill_id);



        $id = $this->executeInsert($sqlQuery);
        $kashf->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param KashfMySql kashf
     */
    public function update($kashf) {
        $sql = 'UPDATE kashf SET kashfvalue = ?, kashftype = ?, customerid = ?, doctorid = ?, kashfdate = ?, entered = ?, paystatus = ? , rondomtxt = ?, branchid = ? , offline = ? , uploaddate = ? , dailyentryid = ? ,kasfhserial = ? , discountkashf = ? , used = ? , bill_id = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($kashf->kashfvalue);
        $sqlQuery->set($kashf->kashftype);
        $sqlQuery->setNumber($kashf->customerid);
        $sqlQuery->setNumber($kashf->doctorid);
        $sqlQuery->set($kashf->kashfdate);
        $sqlQuery->setNumber($kashf->entered);
        $sqlQuery->setNumber($kashf->paystatus);
        $sqlQuery->set($kashf->rondomtxt);
        $sqlQuery->setNumber($kashf->branchid);
        $sqlQuery->setNumber($kashf->offline);
        $sqlQuery->set($kashf->uploaddate);
        $sqlQuery->setNumber($kashf->dailyentryid);
        $sqlQuery->setNumber($kashf->kasfhserial);
        $sqlQuery->setNumber($kashf->discountkashf);
        $sqlQuery->setNumber($kashf->used);
        $sqlQuery->setNumber($kashf->bill_id);

        $sqlQuery->setNumber($kashf->id);

        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM kashf';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByKashfvalue($value) {
        $sql = 'SELECT * FROM kashf WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashftype($value) {
        $sql = 'SELECT * FROM kashf WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomerid($value) {
        $sql = 'SELECT * FROM kashf WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDoctorid($value) {
        $sql = 'SELECT * FROM kashf WHERE doctorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfdate($value) {
        $sql = 'SELECT * FROM kashf WHERE kashfdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEntered($value) {
        $sql = 'SELECT * FROM kashf WHERE entered = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaystatus($value) {
        $sql = 'SELECT * FROM kashf WHERE paystatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByKashfvalue($value) {
        $sql = 'DELETE FROM kashf WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashftype($value) {
        $sql = 'DELETE FROM kashf WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomerid($value) {
        $sql = 'DELETE FROM kashf WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDoctorid($value) {
        $sql = 'DELETE FROM kashf WHERE doctorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfdate($value) {
        $sql = 'DELETE FROM kashf WHERE kashfdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEntered($value) {
        $sql = 'DELETE FROM kashf WHERE entered = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaystatus($value) {
        $sql = 'DELETE FROM kashf WHERE paystatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return KashfMySql
     */
    protected function readRow($row) {
        $kashf = new Kashf();

        $kashf->id = isset($row['id']) ? $row['id'] : '';
        $kashf->kashfvalue = isset($row['kashfvalue']) ? $row['kashfvalue'] : '';
        $kashf->kashftype = isset($row['kashftype']) ? $row['kashftype'] : '';
        $kashf->customerid = isset($row['customerid']) ? $row['customerid'] : '';
        $kashf->doctorid = isset($row['doctorid']) ? $row['doctorid'] : '';
        $kashf->kashfdate = isset($row['kashfdate']) ? $row['kashfdate'] : '';
        $kashf->entered = isset($row['entered']) ? $row['entered'] : '';
        $kashf->paystatus = isset($row['paystatus']) ? $row['paystatus'] : '';
        $kashf->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $kashf->docname = isset($row['docname']) ? $row['docname'] : '';
        $kashf->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';

        $kashf->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $kashf->offline = isset($row['offline']) ? $row['offline'] : '';
        $kashf->uploaddate = isset($row['uploaddate']) ? $row['uploaddate'] : '';
        $kashf->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $kashf->kasfhserial = isset($row['kasfhserial']) ? $row['kasfhserial'] : '';
        $kashf->discountkashf = isset($row['discountkashf']) ? $row['discountkashf'] : '';
        $kashf->used = isset($row['used']) ? $row['used'] : '';
        $kashf->bill_id = isset($row['bill_id']) ? $row['bill_id'] : '';

        return $kashf;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return KashfMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>