<?php

/**
 * Class that operate on table 'entryproductspurchased'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-06-24 12:09
 */
class EntryproductspurchasedMySqlDAO implements EntryproductspurchasedDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EntryproductspurchasedMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM entryproductspurchased';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM entryproductspurchased ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param entryproductspurchased primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM entryproductspurchased WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EntryproductspurchasedMySql entryproductspurchased
     */
    public function insert($entryproductspurchased) {
        $sql = 'INSERT INTO entryproductspurchased (productid, price, productquantity, soldquantity, tablename, modelid, expirationDate, priority, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($entryproductspurchased->productid);
        $sqlQuery->set($entryproductspurchased->price);
        $sqlQuery->set($entryproductspurchased->productquantity);
        $sqlQuery->set($entryproductspurchased->soldquantity);
        $sqlQuery->set($entryproductspurchased->tablename);
        $sqlQuery->setNumber($entryproductspurchased->modelid);
        $sqlQuery->set($entryproductspurchased->expirationDate);
        $sqlQuery->setNumber($entryproductspurchased->priority);
        $sqlQuery->setNumber($entryproductspurchased->del);

        $id = $this->executeInsert($sqlQuery);
        $entryproductspurchased->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EntryproductspurchasedMySql entryproductspurchased
     */
    public function update($entryproductspurchased) {
        $sql = 'UPDATE entryproductspurchased SET productid = ?, price = ?, productquantity = ?, soldquantity = ?, tablename = ?, modelid = ?, expirationDate = ?, priority = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($entryproductspurchased->productid);
        $sqlQuery->set($entryproductspurchased->price);
        $sqlQuery->set($entryproductspurchased->productquantity);
        $sqlQuery->set($entryproductspurchased->soldquantity);
        $sqlQuery->set($entryproductspurchased->tablename);
        $sqlQuery->setNumber($entryproductspurchased->modelid);
        $sqlQuery->set($entryproductspurchased->expirationDate);
        $sqlQuery->setNumber($entryproductspurchased->priority);
        $sqlQuery->setNumber($entryproductspurchased->del);

        $sqlQuery->setNumber($entryproductspurchased->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM entryproductspurchased';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPrice($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductquantity($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySoldquantity($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE soldquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByModelid($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE modelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpirationDate($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE expirationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPriority($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE priority = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM entryproductspurchased WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPrice($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE price = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductquantity($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE productquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySoldquantity($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE soldquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByModelid($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE modelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpirationDate($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE expirationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPriority($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE priority = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM entryproductspurchased WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EntryproductspurchasedMySql
     */
    protected function readRow($row) {
        $entryproductspurchased = new Entryproductspurchased();

        $entryproductspurchased->id = isset($row['id']) ? $row['id'] : '';
        $entryproductspurchased->productid = isset($row['productid']) ? $row['productid'] : '';
        $entryproductspurchased->price = isset($row['price']) ? $row['price'] : '';
        $entryproductspurchased->productquantity = isset($row['productquantity']) ? $row['productquantity'] : '';
        $entryproductspurchased->soldquantity = isset($row['soldquantity']) ? $row['soldquantity'] : '';
        $entryproductspurchased->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $entryproductspurchased->modelid = isset($row['modelid']) ? $row['modelid'] : '';
        $entryproductspurchased->expirationDate = isset($row['expirationDate']) ? $row['expirationDate'] : '';
        $entryproductspurchased->priority = isset($row['priority']) ? $row['priority'] : '';
        $entryproductspurchased->del = isset($row['del']) ? $row['del'] : '';

        return $entryproductspurchased;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EntryproductspurchasedMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>