<?php
/**
 * Class that operate on table 'ebillsetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-04-03 14:18
 */
class EbillsettingMySqlDAO implements EbillsettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EbillsettingMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM ebillsetting WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM ebillsetting';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM ebillsetting ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param ebillsetting primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM ebillsetting WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EbillsettingMySql ebillsetting
 	 */
	public function insert($ebillsetting){
		$sql = 'INSERT INTO ebillsetting (eTaxNum, eTaxNumBranch, eGovernorate, eCity, eStreet, eBuildingNum, eTaxType, eTaxTypeNum, eCompanyNameInTaxCard, eunitInTax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($ebillsetting->eTaxNum);
		$sqlQuery->set($ebillsetting->eTaxNumBranch);
		$sqlQuery->set($ebillsetting->eGovernorate);
		$sqlQuery->set($ebillsetting->eCity);
		$sqlQuery->set($ebillsetting->eStreet);
		$sqlQuery->set($ebillsetting->eBuildingNum);
		$sqlQuery->set($ebillsetting->eTaxType);
		$sqlQuery->set($ebillsetting->eTaxTypeNum);
		$sqlQuery->setString2($ebillsetting->eCompanyNameInTaxCard);
		$sqlQuery->set($ebillsetting->eunitInTax);


		$id = $this->executeInsert($sqlQuery);	
		$ebillsetting->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EbillsettingMySql ebillsetting
 	 */
	public function update($ebillsetting){
		$sql = 'UPDATE ebillsetting SET eTaxNum = ?, eTaxNumBranch = ?, eGovernorate = ?, eCity = ?, eStreet = ?, eBuildingNum = ?, eTaxType = ?, eTaxTypeNum = ?, eCompanyNameInTaxCard = ?, eunitInTax = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($ebillsetting->eTaxNum);
		$sqlQuery->set($ebillsetting->eTaxNumBranch);
		$sqlQuery->set($ebillsetting->eGovernorate);
		$sqlQuery->set($ebillsetting->eCity);
		$sqlQuery->set($ebillsetting->eStreet);
		$sqlQuery->set($ebillsetting->eBuildingNum);
		$sqlQuery->set($ebillsetting->eTaxType);
		$sqlQuery->set($ebillsetting->eTaxTypeNum);
		$sqlQuery->setString2($ebillsetting->eCompanyNameInTaxCard);
		$sqlQuery->set($ebillsetting->eunitInTax);

		$sqlQuery->setNumber($ebillsetting->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM ebillsetting';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByETaxNum($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eTaxNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByETaxNumBranch($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eTaxNumBranch = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEGovernorate($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eGovernorate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByECity($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eCity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEStreet($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eStreet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEBuildingNum($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eBuildingNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByETaxType($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eTaxType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByETaxTypeNum($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eTaxTypeNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByECompanyNameInTaxCard($value){
		$sql = 'SELECT * FROM ebillsetting WHERE eCompanyNameInTaxCard = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByETaxNum($value){
		$sql = 'DELETE FROM ebillsetting WHERE eTaxNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByETaxNumBranch($value){
		$sql = 'DELETE FROM ebillsetting WHERE eTaxNumBranch = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEGovernorate($value){
		$sql = 'DELETE FROM ebillsetting WHERE eGovernorate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByECity($value){
		$sql = 'DELETE FROM ebillsetting WHERE eCity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEStreet($value){
		$sql = 'DELETE FROM ebillsetting WHERE eStreet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEBuildingNum($value){
		$sql = 'DELETE FROM ebillsetting WHERE eBuildingNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByETaxType($value){
		$sql = 'DELETE FROM ebillsetting WHERE eTaxType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByETaxTypeNum($value){
		$sql = 'DELETE FROM ebillsetting WHERE eTaxTypeNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByECompanyNameInTaxCard($value){
		$sql = 'DELETE FROM ebillsetting WHERE eCompanyNameInTaxCard = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EbillsettingMySql 
	 */
	protected function readRow($row){
		$ebillsetting = new Ebillsetting();
		
		$ebillsetting->id = $row['id'];
		$ebillsetting->eTaxNum = $row['eTaxNum'];
		$ebillsetting->eTaxNumBranch = $row['eTaxNumBranch'];
		$ebillsetting->eGovernorate = $row['eGovernorate'];
		$ebillsetting->eCity = $row['eCity'];
		$ebillsetting->eStreet = $row['eStreet'];
		$ebillsetting->eBuildingNum = $row['eBuildingNum'];
		$ebillsetting->eTaxType = $row['eTaxType'];
		$ebillsetting->eTaxTypeNum = $row['eTaxTypeNum'];
		$ebillsetting->eCompanyNameInTaxCard = $row['eCompanyNameInTaxCard'];
		$ebillsetting->eunitInTax = $row['eunitInTax'];


		return $ebillsetting;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EbillsettingMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>