<?php

/**
 * Class that operate on table 'doctorkashf'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
class DoctorkashfMySqlDAO implements DoctorkashfDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DoctorkashfMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM doctorkashf WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM doctorkashf';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM doctorkashf ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param doctorkashf primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM doctorkashf WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DoctorkashfMySql doctorkashf
     */
    public function insert($doctorkashf) {
        $sql = 'INSERT INTO doctorkashf (rdsphere, rnsphere, rdcylinder, rncylinder, rdaxis, rnaxis, rdprism, rnprism, rdva, rnva, ldsphere, lnsphere, ldcylinder, lncylinder, ldaxis, lnaxis, ldprism, lnprism, ldva, lnva, customerid, kashfid,doctorid,date,loguserid,branchid , rondomtxt , uploaddate , offline , radd   , rbiofocal   , ladd   , lbiofocal  , pd  , bvd ,notes ) VALUES (?,?,?,?,?,?,?,? , ? , ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($doctorkashf->rdsphere);
        $sqlQuery->set($doctorkashf->rnsphere);
        $sqlQuery->set($doctorkashf->rdcylinder);
        $sqlQuery->set($doctorkashf->rncylinder);
        $sqlQuery->set($doctorkashf->rdaxis);
        $sqlQuery->set($doctorkashf->rnaxis);
        $sqlQuery->set($doctorkashf->rdprism);
        $sqlQuery->set($doctorkashf->rnprism);
        $sqlQuery->set($doctorkashf->rdva);
        $sqlQuery->set($doctorkashf->rnva);
        $sqlQuery->set($doctorkashf->ldsphere);
        $sqlQuery->set($doctorkashf->lnsphere);
        $sqlQuery->set($doctorkashf->ldcylinder);
        $sqlQuery->set($doctorkashf->lncylinder);
        $sqlQuery->set($doctorkashf->ldaxis);
        $sqlQuery->set($doctorkashf->lnaxis);
        $sqlQuery->set($doctorkashf->ldprism);
        $sqlQuery->set($doctorkashf->lnprism);
        $sqlQuery->set($doctorkashf->ldva);
        $sqlQuery->set($doctorkashf->lnva);
        $sqlQuery->setNumber($doctorkashf->customerid);
        $sqlQuery->setNumber($doctorkashf->kashfid);
        $sqlQuery->setNumber($doctorkashf->doctorid);

        $sqlQuery->set($doctorkashf->date);
        $sqlQuery->setNumber($doctorkashf->loguserid);
        $sqlQuery->setNumber($doctorkashf->branchid);

        $sqlQuery->set($doctorkashf->rondomtxt);

        $sqlQuery->set($doctorkashf->uploaddate);
        $sqlQuery->setNumber($doctorkashf->offline);

        $sqlQuery->set($doctorkashf->radd);
        $sqlQuery->set($doctorkashf->rbiofocal);
        $sqlQuery->set($doctorkashf->ladd);
        $sqlQuery->set($doctorkashf->lbiofocal);
        $sqlQuery->set($doctorkashf->pd);
        $sqlQuery->set($doctorkashf->bvd);
        $sqlQuery->set($doctorkashf->notes);


        $id = $this->executeInsert($sqlQuery);
        $doctorkashf->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DoctorkashfMySql doctorkashf
     */
    public function update($doctorkashf) {
        $sql = 'UPDATE doctorkashf SET rdsphere = ?, rnsphere = ?, rdcylinder = ?, rncylinder = ?, rdaxis = ?, rnaxis = ?, rdprism = ?, rnprism = ?, rdva = ?, rnva = ?, ldsphere = ?, lnsphere = ?, ldcylinder = ?, lncylinder = ?, ldaxis = ?, lnaxis = ?, ldprism = ?, lnprism = ?, ldva = ?, lnva = ?, customerid = ?, kashfid = ? , doctorid = ? , date = ? , loguserid = ? , branchid = ? , rondomtxt = ? , uploaddate = ? , offline = ? , radd = ?   , rbiofocal = ?   , ladd = ?   , lbiofocal = ?  , pd = ?  , bvd = ? ,notes = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($doctorkashf->rdsphere);
        $sqlQuery->set($doctorkashf->rnsphere);
        $sqlQuery->set($doctorkashf->rdcylinder);
        $sqlQuery->set($doctorkashf->rncylinder);
        $sqlQuery->set($doctorkashf->rdaxis);
        $sqlQuery->set($doctorkashf->rnaxis);
        $sqlQuery->set($doctorkashf->rdprism);
        $sqlQuery->set($doctorkashf->rnprism);
        $sqlQuery->set($doctorkashf->rdva);
        $sqlQuery->set($doctorkashf->rnva);
        $sqlQuery->set($doctorkashf->ldsphere);
        $sqlQuery->set($doctorkashf->lnsphere);
        $sqlQuery->set($doctorkashf->ldcylinder);
        $sqlQuery->set($doctorkashf->lncylinder);
        $sqlQuery->set($doctorkashf->ldaxis);
        $sqlQuery->set($doctorkashf->lnaxis);
        $sqlQuery->set($doctorkashf->ldprism);
        $sqlQuery->set($doctorkashf->lnprism);
        $sqlQuery->set($doctorkashf->ldva);
        $sqlQuery->set($doctorkashf->lnva);
        $sqlQuery->setNumber($doctorkashf->customerid);
        $sqlQuery->setNumber($doctorkashf->kashfid);
        $sqlQuery->setNumber($doctorkashf->doctorid);
        $sqlQuery->set($doctorkashf->date);
        $sqlQuery->setNumber($doctorkashf->loguserid);
        $sqlQuery->setNumber($doctorkashf->branchid);

        $sqlQuery->set($doctorkashf->rondomtxt);

        $sqlQuery->set($doctorkashf->uploaddate);
        $sqlQuery->setNumber($doctorkashf->offline);


        $sqlQuery->set($doctorkashf->radd);
        $sqlQuery->set($doctorkashf->rbiofocal);
        $sqlQuery->set($doctorkashf->ladd);
        $sqlQuery->set($doctorkashf->lbiofocal);
        $sqlQuery->set($doctorkashf->pd);
        $sqlQuery->set($doctorkashf->bvd);
        $sqlQuery->set($doctorkashf->notes);

        $sqlQuery->setNumber($doctorkashf->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM doctorkashf';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRdsphere($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rdsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRnsphere($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rnsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRdcylinder($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rdcylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRncylinder($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rncylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRdaxis($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rdaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRnaxis($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rnaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRdprism($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rdprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRnprism($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rnprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRdva($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rdva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRnva($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE rnva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLdsphere($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE ldsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLnsphere($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE lnsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLdcylinder($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE ldcylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLncylinder($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE lncylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLdaxis($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE ldaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLnaxis($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE lnaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLdprism($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE ldprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLnprism($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE lnprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLdva($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE ldva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLnva($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE lnva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomerid($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfid($value) {
        $sql = 'SELECT * FROM doctorkashf WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRdsphere($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rdsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRnsphere($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rnsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRdcylinder($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rdcylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRncylinder($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rncylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRdaxis($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rdaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRnaxis($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rnaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRdprism($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rdprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRnprism($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rnprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRdva($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rdva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRnva($value) {
        $sql = 'DELETE FROM doctorkashf WHERE rnva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLdsphere($value) {
        $sql = 'DELETE FROM doctorkashf WHERE ldsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLnsphere($value) {
        $sql = 'DELETE FROM doctorkashf WHERE lnsphere = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLdcylinder($value) {
        $sql = 'DELETE FROM doctorkashf WHERE ldcylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLncylinder($value) {
        $sql = 'DELETE FROM doctorkashf WHERE lncylinder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLdaxis($value) {
        $sql = 'DELETE FROM doctorkashf WHERE ldaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLnaxis($value) {
        $sql = 'DELETE FROM doctorkashf WHERE lnaxis = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLdprism($value) {
        $sql = 'DELETE FROM doctorkashf WHERE ldprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLnprism($value) {
        $sql = 'DELETE FROM doctorkashf WHERE lnprism = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLdva($value) {
        $sql = 'DELETE FROM doctorkashf WHERE ldva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLnva($value) {
        $sql = 'DELETE FROM doctorkashf WHERE lnva = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomerid($value) {
        $sql = 'DELETE FROM doctorkashf WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfid($value) {
        $sql = 'DELETE FROM doctorkashf WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DoctorkashfMySql
     */
    protected function readRow($row) {
        $doctorkashf = new Doctorkashf();

        $doctorkashf->id = isset($row['id']) ? $row['id'] : '';
        $doctorkashf->rdsphere = isset($row['rdsphere']) ? $row['rdsphere'] : '';
        $doctorkashf->rnsphere = isset($row['rnsphere']) ? $row['rnsphere'] : '';
        $doctorkashf->rdcylinder = isset($row['rdcylinder']) ? $row['rdcylinder'] : '';
        $doctorkashf->rncylinder = isset($row['rncylinder']) ? $row['rncylinder'] : '';
        $doctorkashf->rdaxis = isset($row['rdaxis']) ? $row['rdaxis'] : '';
        $doctorkashf->rnaxis = isset($row['rnaxis']) ? $row['rnaxis'] : '';
        $doctorkashf->rdprism = isset($row['rdprism']) ? $row['rdprism'] : '';
        $doctorkashf->rnprism = isset($row['rnprism']) ? $row['rnprism'] : '';
        $doctorkashf->rdva = isset($row['rdva']) ? $row['rdva'] : '';
        $doctorkashf->rnva = isset($row['rnva']) ? $row['rnva'] : '';
        $doctorkashf->ldsphere = isset($row['ldsphere']) ? $row['ldsphere'] : '';
        $doctorkashf->lnsphere = isset($row['lnsphere']) ? $row['lnsphere'] : '';
        $doctorkashf->ldcylinder = isset($row['ldcylinder']) ? $row['ldcylinder'] : '';
        $doctorkashf->lncylinder = isset($row['lncylinder']) ? $row['lncylinder'] : '';
        $doctorkashf->ldaxis = isset($row['ldaxis']) ? $row['ldaxis'] : '';
        $doctorkashf->lnaxis = isset($row['lnaxis']) ? $row['lnaxis'] : '';
        $doctorkashf->ldprism = isset($row['ldprism']) ? $row['ldprism'] : '';
        $doctorkashf->lnprism = isset($row['lnprism']) ? $row['lnprism'] : '';
        $doctorkashf->ldva = isset($row['ldva']) ? $row['ldva'] : '';
        $doctorkashf->lnva = isset($row['lnva']) ? $row['lnva'] : '';
        $doctorkashf->customerid = isset($row['customerid']) ? $row['customerid'] : '';
        $doctorkashf->kashfid = isset($row['kashfid']) ? $row['kashfid'] : '';
        $doctorkashf->doctorid = isset($row['doctorid']) ? $row['doctorid'] : '';
        $doctorkashf->date = isset($row['date']) ? $row['date'] : '';
        $doctorkashf->docName = isset($row['docName']) ? $row['docName'] : '';
        $doctorkashf->clientName = isset($row['clientName']) ? $row['clientName'] : '';
        $doctorkashf->loguserid = isset($row['loguserid']) ? $row['loguserid'] : '';
        $doctorkashf->branchid = isset($row['branchid']) ? $row['branchid'] : '';

        $doctorkashf->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';
        $doctorkashf->uploaddate = isset($row['uploaddate']) ? $row['uploaddate'] : '';
        $doctorkashf->offline = isset($row['offline']) ? $row['offline'] : '';

        $doctorkashf->radd = isset($row['accountid']) ? $row['radd'] : '';
        $doctorkashf->rbiofocal = isset($row['rbiofocal']) ? $row['rbiofocal'] : '';
        $doctorkashf->ladd = isset($row['ladd']) ? $row['ladd'] : '';
        $doctorkashf->lbiofocal = isset($row['lbiofocal']) ? $row['lbiofocal'] : '';
        $doctorkashf->pd = isset($row['pd']) ? $row['pd'] : '';
        $doctorkashf->bvd = isset($row['bvd']) ? $row['bvd'] : '';
        $doctorkashf->notes = isset($row['notes']) ? $row['notes'] : '';


        return $doctorkashf;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DoctorkashfMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>