<?php
/**
 * Class that operate on table 'discountcontrol'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-02-03 23:20
 */
class DiscountcontrolMySqlDAO implements DiscountcontrolDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return DiscountcontrolMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM discountcontrol WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM discountcontrol';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM discountcontrol ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param discountcontrol primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM discountcontrol WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param DiscountcontrolMySql discountcontrol
 	 */
	public function insert($discountcontrol){
		$sql = 'INSERT INTO discountcontrol (totalFrom, totalTo, discount, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($discountcontrol->totalFrom);
		$sqlQuery->set($discountcontrol->totalTo);
		$sqlQuery->set($discountcontrol->discount);
		$sqlQuery->setNumber($discountcontrol->userid);
		$sqlQuery->set($discountcontrol->sysdate);
		$sqlQuery->setNumber($discountcontrol->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$discountcontrol->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param DiscountcontrolMySql discountcontrol
 	 */
	public function update($discountcontrol){
		$sql = 'UPDATE discountcontrol SET totalFrom = ?, totalTo = ?, discount = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($discountcontrol->totalFrom);
		$sqlQuery->set($discountcontrol->totalTo);
		$sqlQuery->set($discountcontrol->discount);
		$sqlQuery->setNumber($discountcontrol->userid);
		$sqlQuery->set($discountcontrol->sysdate);
		$sqlQuery->setNumber($discountcontrol->conditions);

		$sqlQuery->setNumber($discountcontrol->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM discountcontrol';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTotalFrom($value){
		$sql = 'SELECT * FROM discountcontrol WHERE totalFrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalTo($value){
		$sql = 'SELECT * FROM discountcontrol WHERE totalTo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDiscount($value){
		$sql = 'SELECT * FROM discountcontrol WHERE discount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM discountcontrol WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM discountcontrol WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM discountcontrol WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTotalFrom($value){
		$sql = 'DELETE FROM discountcontrol WHERE totalFrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalTo($value){
		$sql = 'DELETE FROM discountcontrol WHERE totalTo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDiscount($value){
		$sql = 'DELETE FROM discountcontrol WHERE discount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM discountcontrol WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM discountcontrol WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM discountcontrol WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return DiscountcontrolMySql 
	 */
	protected function readRow($row){
		$discountcontrol = new Discountcontrol();
		
		$discountcontrol->id = $row['id'];
		$discountcontrol->totalFrom = $row['totalFrom'];
		$discountcontrol->totalTo = $row['totalTo'];
		$discountcontrol->discount = $row['discount'];
		$discountcontrol->userid = $row['userid'];
		$discountcontrol->sysdate = $row['sysdate'];
		$discountcontrol->conditions = $row['conditions'];

		return $discountcontrol;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return DiscountcontrolMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>