<?php

/**
 * Class that operate on table 'costcenter'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-03-13 17:56
 */
class CostcenterMySqlDAO implements CostcenterDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CostcenterMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM costcenter WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM costcenter';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM costcenter ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param costcenter primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM costcenter WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CostcenterMySql costcenter
     */
    public function insert($costcenter) {
        $sql = 'INSERT INTO costcenter (name, comment, condation) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($costcenter->name);
        $sqlQuery->setString2($costcenter->comment);
        $sqlQuery->setNumber($costcenter->condation);

        $id = $this->executeInsert($sqlQuery);
        $costcenter->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CostcenterMySql costcenter
     */
    public function update($costcenter) {
        $sql = 'UPDATE costcenter SET name = ?, comment = ?, condation = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($costcenter->name);
        $sqlQuery->setString2($costcenter->comment);
        $sqlQuery->setNumber($costcenter->condation);

        $sqlQuery->setNumber($costcenter->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM costcenter';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM costcenter WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM costcenter WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondation($value) {
        $sql = 'SELECT * FROM costcenter WHERE condation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM costcenter WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM costcenter WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondation($value) {
        $sql = 'DELETE FROM costcenter WHERE condation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CostcenterMySql
     */
    protected function readRow($row) {
        $costcenter = new Costcenter();

        $costcenter->id = isset($row['id']) ? $row['id'] : '';
        $costcenter->name = isset($row['name']) ? $row['name'] : '';
        $costcenter->comment = isset($row['comment']) ? $row['comment'] : '';
        $costcenter->condation = isset($row['condation']) ? $row['condation'] : '';

        return $costcenter;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CostcenterMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>