<?php
/**
 * Class that operate on table 'commentclient'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-04-21 22:17
 */
class CommentclientMySqlDAO implements CommentclientDAO{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CommentclientMySql
     */
    public function load($id){
        $sql = 'SELECT * FROM commentclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll(){
        $sql = 'SELECT * FROM commentclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn){
        $sql = 'SELECT * FROM commentclient ORDER BY '.$orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param commentclient primary key
     */
    public function delete($id){
        $sql = 'DELETE FROM commentclient WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CommentclientMySql commentclient
     */
    public function insert($commentclient){
        $sql = 'INSERT INTO commentclient (clientid, userid, comments, commentdate) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($commentclient->clientid);
        $sqlQuery->setNumber($commentclient->userid);
        $sqlQuery->setString2($commentclient->comments);
        $sqlQuery->set($commentclient->commentdate);

        $id = $this->executeInsert($sqlQuery);
        $commentclient->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CommentclientMySql commentclient
     */
    public function update($commentclient){
        $sql = 'UPDATE commentclient SET clientid = ?, userid = ?, comments = ?, commentdate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($commentclient->clientid);
        $sqlQuery->setNumber($commentclient->userid);
        $sqlQuery->setString2($commentclient->comments);
        $sqlQuery->set($commentclient->commentdate);

        $sqlQuery->setNumber($commentclient->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean(){
        $sql = 'DELETE FROM commentclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value){
        $sql = 'SELECT * FROM commentclient WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value){
        $sql = 'SELECT * FROM commentclient WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComments($value){
        $sql = 'SELECT * FROM commentclient WHERE comments = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCommentdate($value){
        $sql = 'SELECT * FROM commentclient WHERE commentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }


    public function deleteByClientid($value){
        $sql = 'DELETE FROM commentclient WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value){
        $sql = 'DELETE FROM commentclient WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComments($value){
        $sql = 'DELETE FROM commentclient WHERE comments = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCommentdate($value){
        $sql = 'DELETE FROM commentclient WHERE commentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }



    /**
     * Read row
     *
     * @return CommentclientMySql
     */
    protected function readRow($row){
        $commentclient = new Commentclient();

        $commentclient->id = $row['id'];
        $commentclient->clientid = $row['clientid'];
        $commentclient->userid = $row['userid'];
        $commentclient->comments = $row['comments'];
        $commentclient->commentdate = $row['commentdate'];
        $commentclient->userid = isset($row['userid']) ? $row['userid'] : '';
        $commentclient->username = isset($row['username']) ? $row['username'] : '';
        $commentclient->password = isset($row['password']) ? $row['password'] : '';
        $commentclient->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $commentclient->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $commentclient->processname = isset($row['processname']) ? $row['processname'] : '';
        $commentclient->clientdebtchangedate = isset($row['clientdebtchangedate']) ? $row['clientdebtchangedate'] : '';

        return $commentclient;
    }

    protected function getList($sqlQuery){
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for($i=0;$i<count($tab);$i++){
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CommentclientMySql
     */
    protected function getRow($sqlQuery){
        $tab = QueryExecutor::execute($sqlQuery);
        if(count($tab)==0){
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery){
        return QueryExecutor::execute($sqlQuery);
    }


    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery){
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery){
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery){
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
?>