<?php
/**
 * Class that operate on table 'collectedparcodestemp'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-10-19 19:01
 */
class CollectedparcodestempMySqlDAO implements CollectedparcodestempDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return CollectedparcodestempMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM collectedparcodestemp';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM collectedparcodestemp ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param collectedparcodestemp primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM collectedparcodestemp WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param CollectedparcodestempMySql collectedparcodestemp
 	 */
	public function insert($collectedparcodestemp){
		$sql = 'INSERT INTO collectedparcodestemp (userid, sellerid, parcodes, sysdate, conditions) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($collectedparcodestemp->userid);
		$sqlQuery->setNumber($collectedparcodestemp->sellerid);
		$sqlQuery->setString2($collectedparcodestemp->parcodes);
		$sqlQuery->set($collectedparcodestemp->sysdate);
		$sqlQuery->setNumber($collectedparcodestemp->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$collectedparcodestemp->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param CollectedparcodestempMySql collectedparcodestemp
 	 */
	public function update($collectedparcodestemp){
		$sql = 'UPDATE collectedparcodestemp SET userid = ?, sellerid = ?, parcodes = ?, sysdate = ?, conditions = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($collectedparcodestemp->userid);
		$sqlQuery->setNumber($collectedparcodestemp->sellerid);
		$sqlQuery->setString2($collectedparcodestemp->parcodes);
		$sqlQuery->set($collectedparcodestemp->sysdate);
		$sqlQuery->setNumber($collectedparcodestemp->conditions);

		$sqlQuery->setNumber($collectedparcodestemp->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM collectedparcodestemp';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellerid($value){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE sellerid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByParcodes($value){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE parcodes = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM collectedparcodestemp WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserid($value){
		$sql = 'DELETE FROM collectedparcodestemp WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellerid($value){
		$sql = 'DELETE FROM collectedparcodestemp WHERE sellerid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByParcodes($value){
		$sql = 'DELETE FROM collectedparcodestemp WHERE parcodes = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM collectedparcodestemp WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM collectedparcodestemp WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return CollectedparcodestempMySql 
	 */
	protected function readRow($row){
		$collectedparcodestemp = new Collectedparcodestemp();
		
		$collectedparcodestemp->id = $row['id'];
		$collectedparcodestemp->userid = $row['userid'];
		$collectedparcodestemp->sellerid = $row['sellerid'];
		$collectedparcodestemp->parcodes = $row['parcodes'];
		$collectedparcodestemp->sysdate = $row['sysdate'];
		$collectedparcodestemp->conditions = $row['conditions'];

		return $collectedparcodestemp;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return CollectedparcodestempMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>