<?php

/**
 * Class that operate on table 'buybilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BuybilldetailMySqlDAO implements BuybilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuybilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buybilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buybilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buybilldetail primary key
     */
    public function delete($buybilldetailid) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuybilldetailMySql buybilldetail
     */
    public function insert($buybilldetail) {
        $sql = 'INSERT INTO buybilldetail (Parcode, buybillid, buybilldetailcatid, buybilldetailproductid, buybilldetailquantity, buybilldetailprice, buybilldetailtotalprice, discountvalue, note, buybilldetaildate, productunitid,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid,quantitybefore, buybilldetailpriceC, buybilldetailtotalpriceC, discountvalueC,discounttype,rowtaxval,rowtaxper,lastbuyprice_withTax,meanbuyprice_withTax,probuyDiscountPer,lastbuyprice_withDiscountAndTax,storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilldetail->parcode);
        $sqlQuery->setNumber($buybilldetail->buybillid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailcatid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailproductid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailquantity);
        $sqlQuery->set($buybilldetail->buybilldetailprice);
        $sqlQuery->set($buybilldetail->buybilldetailtotalprice);
        $sqlQuery->set($buybilldetail->discountvalue);
        $sqlQuery->set($buybilldetail->note);
        $sqlQuery->set($buybilldetail->buybilldetaildate);
        $sqlQuery->setNumber($buybilldetail->productunitid);
        $sqlQuery->set($buybilldetail->lastbuyprice);
        $sqlQuery->set($buybilldetail->meanbuyprice);
        $sqlQuery->set((float) $buybilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $buybilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $buybilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $buybilldetail->sizeid);
        $sqlQuery->setNumber((int) $buybilldetail->colorid);
        $sqlQuery->setNumber($buybilldetail->quantitybefore); //not casting it to float as i need it null if empty
        $sqlQuery->setNumber((float) $buybilldetail->buybilldetailpriceC);
        $sqlQuery->setNumber((float) $buybilldetail->buybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $buybilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $buybilldetail->discounttype);
        $sqlQuery->setNumber((float) $buybilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $buybilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $buybilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $buybilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $buybilldetail->probuyDiscountPer);
        $sqlQuery->setNumber((float) $buybilldetail->lastbuyprice_withDiscountAndTax);
        $sqlQuery->setNumber((int) $buybilldetail->storeid);


        $id = $this->executeInsert($sqlQuery);
        $buybilldetail->buybilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuybilldetailMySql buybilldetail
     */
    public function update($buybilldetail) {
        $sql = 'UPDATE buybilldetail SET Parcode = ?, buybillid = ?, buybilldetailcatid = ?, buybilldetailproductid = ?, buybilldetailquantity = ?, buybilldetailprice = ?, buybilldetailtotalprice = ?, discountvalue = ?, note = ?, buybilldetaildate = ?, productunitid = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid= ?,quantitybefore = ?, buybilldetailpriceC = ?, buybilldetailtotalpriceC = ?, discountvalueC = ?,discounttype=?,rowtaxval=?,rowtaxper=?,lastbuyprice_withTax=?,meanbuyprice_withTax=?,probuyDiscountPer=?,lastbuyprice_withDiscountAndTax=?,storeid=? WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilldetail->parcode);
        $sqlQuery->setNumber($buybilldetail->buybillid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailcatid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailproductid);
        $sqlQuery->setNumber($buybilldetail->buybilldetailquantity);
        $sqlQuery->set($buybilldetail->buybilldetailprice);
        $sqlQuery->set($buybilldetail->buybilldetailtotalprice);
        $sqlQuery->set($buybilldetail->discountvalue);
        $sqlQuery->set($buybilldetail->note);
        $sqlQuery->set($buybilldetail->buybilldetaildate);
        $sqlQuery->setNumber($buybilldetail->productunitid);
        $sqlQuery->set($buybilldetail->lastbuyprice);
        $sqlQuery->set($buybilldetail->meanbuyprice);
        $sqlQuery->set((float) $buybilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $buybilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $buybilldetail->sizeid);
        $sqlQuery->setNumber((int) $buybilldetail->colorid);
        $sqlQuery->setNumber($buybilldetail->quantitybefore); //not casting it to float as i need it null if empty
        $sqlQuery->setNumber((float) $buybilldetail->buybilldetailpriceC);
        $sqlQuery->setNumber((float) $buybilldetail->buybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $buybilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $buybilldetail->discounttype);
        $sqlQuery->setNumber((float) $buybilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $buybilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $buybilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $buybilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $buybilldetail->probuyDiscountPer);
        $sqlQuery->setNumber((float) $buybilldetail->lastbuyprice_withDiscountAndTax);
        $sqlQuery->setNumber((int) $buybilldetail->storeid);

        $sqlQuery->setNumber($buybilldetail->buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buybilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillid($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailcatid($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailproductid($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailproductid = ? ORDER BY `buybilldetail`.`buybilldetailid` DESC limit 1';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailquantity($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailprice($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailtotalprice($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM buybilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM buybilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillid($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailcatid($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailproductid($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailquantity($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailprice($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailtotalprice($value) {
        $sql = 'DELETE FROM buybilldetail WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM buybilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM buybilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuybilldetailMySql
     */
    protected function readRow($row) {
        $buybilldetail = new Buybilldetail();

        $buybilldetail->parcode = isset($row['Parcode']) ? $row['Parcode'] : '';
        $buybilldetail->buybilldetailid = isset($row['buybilldetailid']) ? $row['buybilldetailid'] : '';
        $buybilldetail->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $buybilldetail->buybilldetailcatid = isset($row['buybilldetailcatid']) ? $row['buybilldetailcatid'] : '';
        $buybilldetail->buybilldetailproductid = isset($row['buybilldetailproductid']) ? $row['buybilldetailproductid'] : '';
        $buybilldetail->buybilldetailquantity = isset($row['buybilldetailquantity']) ? $row['buybilldetailquantity'] : '';
        $buybilldetail->buybilldetailprice = isset($row['buybilldetailprice']) ? $row['buybilldetailprice'] : '';
        $buybilldetail->buybilldetailtotalprice = isset($row['buybilldetailtotalprice']) ? $row['buybilldetailtotalprice'] : '';
        $buybilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $buybilldetail->note = isset($row['note']) ? $row['note'] : '';
        $buybilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $buybilldetail->parcode = isset($row['Parcode']) ? $row['Parcode'] : '';
        $buybilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $buybilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $buybilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $buybilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $buybilldetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $buybilldetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $buybilldetail->probuyDiscountPer = isset($row['probuyDiscountPer']) ? $row['probuyDiscountPer'] : '';
        $buybilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $buybilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $buybilldetail->buybilldetailpriceC = isset($row['buybilldetailpriceC']) ? $row['buybilldetailpriceC'] : '';
        $buybilldetail->buybilldetailtotalpriceC = isset($row['buybilldetailtotalpriceC']) ? $row['buybilldetailtotalpriceC'] : '';
        $buybilldetail->discountvalueC = isset($row['discountvalueC']) ? $row['discountvalueC'] : '';
        $buybilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $buybilldetail->rowtaxval = isset($row['rowtaxval']) ? $row['rowtaxval'] : '';
        $buybilldetail->rowtaxper = isset($row['rowtaxper']) ? $row['rowtaxper'] : '';
        $buybilldetail->lastbuyprice_withDiscountAndTax = isset($row['lastbuyprice_withDiscountAndTax']) ? $row['lastbuyprice_withDiscountAndTax'] : '';
        $buybilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        //required
        $buybilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $buybilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $buybilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $buybilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $buybilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $buybilldetail->totalQty = isset($row['totalQty']) ? $row['totalQty'] : '';
        $buybilldetail->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $buybilldetail->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $buybilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';
        $buybilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $buybilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $buybilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $buybilldetail->typeOfBill = isset($row['typeOfBill']) ? $row['typeOfBill'] : '';
        $buybilldetail->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $buybilldetail->buybilltotalbill = isset($row['buybilltotalbill']) ? $row['buybilltotalbill'] : '';
        $buybilldetail->quantitybefore = isset($row['quantitybefore']) ? $row['quantitybefore'] : '';
        $buybilldetail->overallAverage = isset($row['overallAverage']) ? $row['overallAverage'] : '';
        $buybilldetail->logo = isset($row['logo']) ? $row['logo'] : '';
        $buybilldetail->buybilldiscount = isset($row['buybilldiscount']) ? $row['buybilldiscount'] : '';
        $buybilldetail->buybilldiscountrype = isset($row['buybilldiscountrype']) ? $row['buybilldiscountrype'] : '';
        $buybilldetail->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $buybilldetail->payedtax = isset($row['payedtax']) ? $row['payedtax'] : '';
        $buybilldetail->buybillsysdate = isset($row['buybillsysdate']) ? $row['buybillsysdate'] : '';


        return $buybilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuybilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}
