<?php

/**
 * Class that operate on table 'buyandruternbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-29 13:54
 */
class BuyandruternbilldetailMySqlDAO implements BuyandruternbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuyandruternbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buyandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buyandruternbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buyandruternbilldetail primary key
     */
    public function delete($buybilldetailid) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuyandruternbilldetailMySql buyandruternbilldetail
     */
    public function insert($buyandruternbilldetail) {
        $sql = 'INSERT INTO buyandruternbilldetail (Parcode, buybillid, buybilldetailcatid, buybilldetailproductid, buybilldetailquantity, buybilldetailprice, buybilldetailtotalprice, discountvalue, note, buybilldetaildate, billtype, productunitid,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid,quantitybefore, buybilldetailpriceC, buybilldetailtotalpriceC, discountvalueC,discounttype,rowtaxval,rowtaxper,lastbuyprice_withTax,meanbuyprice_withTax,lastbuyprice_withDiscountAndTax,storeid)'
                . ' VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buyandruternbilldetail->parcode);
        $sqlQuery->setNumber($buyandruternbilldetail->buybillid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailcatid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailproductid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailquantity);
        $sqlQuery->set($buyandruternbilldetail->buybilldetailprice);
        $sqlQuery->set($buyandruternbilldetail->buybilldetailtotalprice);
        $sqlQuery->set($buyandruternbilldetail->discountvalue);
        $sqlQuery->set($buyandruternbilldetail->note);
        $sqlQuery->set($buyandruternbilldetail->buybilldetaildate);
        $sqlQuery->setNumber($buyandruternbilldetail->billtype);
        $sqlQuery->setNumber($buyandruternbilldetail->productunitid);
        $sqlQuery->set($buyandruternbilldetail->lastbuyprice);
        $sqlQuery->set($buyandruternbilldetail->meanbuyprice);
        $sqlQuery->set((float) $buyandruternbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $buyandruternbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->sizeid);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->colorid);
        $sqlQuery->setNumber($buyandruternbilldetail->quantitybefore); //not casting it to float as i need it null if empty
        $sqlQuery->setNumber((float) $buyandruternbilldetail->buybilldetailpriceC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->buybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->discounttype);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->lastbuyprice_withDiscountAndTax);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->storeid);

        $id = $this->executeInsert($sqlQuery);
        $buyandruternbilldetail->buybilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuyandruternbilldetailMySql buyandruternbilldetail
     */
    public function update($buyandruternbilldetail) {
        $sql = 'UPDATE buyandruternbilldetail SET Parcode = ?, buybillid = ?, buybilldetailcatid = ?, buybilldetailproductid = ?, buybilldetailquantity = ?, buybilldetailprice = ?, buybilldetailtotalprice = ?, discountvalue = ?, note = ?, buybilldetaildate = ?, billtype = ?, productunitid = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid= ?,quantitybefore = ?, buybilldetailpriceC = ?, buybilldetailtotalpriceC = ?, discountvalueC = ?,discounttype=?,rowtaxval=?,rowtaxper=?,lastbuyprice_withTax=?,meanbuyprice_withTax=?,lastbuyprice_withDiscountAndTax=?,storeid=? WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buyandruternbilldetail->parcode);
        $sqlQuery->setNumber($buyandruternbilldetail->buybillid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailcatid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailproductid);
        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailquantity);
        $sqlQuery->set($buyandruternbilldetail->buybilldetailprice);
        $sqlQuery->set($buyandruternbilldetail->buybilldetailtotalprice);
        $sqlQuery->set($buyandruternbilldetail->discountvalue);
        $sqlQuery->set($buyandruternbilldetail->note);
        $sqlQuery->set($buyandruternbilldetail->buybilldetaildate);
        $sqlQuery->setNumber($buyandruternbilldetail->billtype);
        $sqlQuery->setNumber($buyandruternbilldetail->productunitid);
        $sqlQuery->set($buyandruternbilldetail->lastbuyprice);
        $sqlQuery->set($buyandruternbilldetail->meanbuyprice);
        $sqlQuery->set((float) $buyandruternbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $buyandruternbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->sizeid);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->colorid);
        $sqlQuery->setNumber($buyandruternbilldetail->quantitybefore); //not casting it to float as i need it null if empty
        $sqlQuery->setNumber((float) $buyandruternbilldetail->buybilldetailpriceC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->buybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->discounttype);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $buyandruternbilldetail->lastbuyprice_withDiscountAndTax);
        $sqlQuery->setNumber((int) $buyandruternbilldetail->storeid);

        $sqlQuery->setNumber($buyandruternbilldetail->buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buyandruternbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillid($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailcatid($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailproductid($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailquantity($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailprice($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailtotalprice($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetaildate($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE buybilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBilltype($value) {
        $sql = 'SELECT * FROM buyandruternbilldetail WHERE billtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillid($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailcatid($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailproductid($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailquantity($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailprice($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailtotalprice($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetaildate($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE buybilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBilltype($value) {
        $sql = 'DELETE FROM buyandruternbilldetail WHERE billtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuyandruternbilldetailMySql
     */
    protected function readRow($row) {
        $buyandruternbilldetail = new Buyandruternbilldetail();

        $buyandruternbilldetail->parcode = isset($row['Parcode']) ? $row['Parcode'] : '';
        $buyandruternbilldetail->buybilldetailid = isset($row['buybilldetailid']) ? $row['buybilldetailid'] : '';
        $buyandruternbilldetail->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $buyandruternbilldetail->buybilldetailcatid = isset($row['buybilldetailcatid']) ? $row['buybilldetailcatid'] : '';
        $buyandruternbilldetail->buybilldetailproductid = isset($row['buybilldetailproductid']) ? $row['buybilldetailproductid'] : '';
        $buyandruternbilldetail->buybilldetailquantity = isset($row['buybilldetailquantity']) ? $row['buybilldetailquantity'] : '';
        $buyandruternbilldetail->buybilldetailprice = isset($row['buybilldetailprice']) ? $row['buybilldetailprice'] : '';
        $buyandruternbilldetail->buybilldetailtotalprice = isset($row['buybilldetailtotalprice']) ? $row['buybilldetailtotalprice'] : '';
        $buyandruternbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $buyandruternbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $buyandruternbilldetail->buybilldetaildate = isset($row['buybilldetaildate']) ? $row['buybilldetaildate'] : '';
        $buyandruternbilldetail->billtype = isset($row['billtype']) ? $row['billtype'] : '';
        $buyandruternbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';

        $buyandruternbilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $buyandruternbilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $buyandruternbilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $buyandruternbilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $buyandruternbilldetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $buyandruternbilldetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $buyandruternbilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';
        $buyandruternbilldetail->lastbuyprice_withDiscountAndTax = isset($row['lastbuyprice_withDiscountAndTax']) ? $row['lastbuyprice_withDiscountAndTax'] : '';
        $buyandruternbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        $buyandruternbilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $buyandruternbilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $buyandruternbilldetail->buybilldetailpriceC = isset($row['buybilldetailpriceC']) ? $row['buybilldetailpriceC'] : '';
        $buyandruternbilldetail->buybilldetailtotalpriceC = isset($row['buybilldetailtotalpriceC']) ? $row['buybilldetailtotalpriceC'] : '';
        $buyandruternbilldetail->discountvalueC = isset($row['discountvalueC']) ? $row['discountvalueC'] : '';
        $buyandruternbilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $buyandruternbilldetail->rowtaxval = isset($row['rowtaxval']) ? $row['rowtaxval'] : '';
        $buyandruternbilldetail->rowtaxper = isset($row['rowtaxper']) ? $row['rowtaxper'] : '';


        //required
        $buyandruternbilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $buyandruternbilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $buyandruternbilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';

        $buyandruternbilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $buyandruternbilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $buyandruternbilldetail->totalQty = isset($row['totalQty']) ? $row['totalQty'] : '';

        $buyandruternbilldetail->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $buyandruternbilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        $buyandruternbilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $buyandruternbilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $buyandruternbilldetail->quantitybefore = isset($row['quantitybefore']) ? $row['quantitybefore'] : '';
        $buyandruternbilldetail->logo = isset($row['logo']) ? $row['logo'] : '';
        $buyandruternbilldetail->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $buyandruternbilldetail->payedtax = isset($row['payedtax']) ? $row['payedtax'] : '';

        return $buyandruternbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuyandruternbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>