<?php

/**
 * Class that operate on table 'branch'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-10 14:26
 */
class BranchMySqlDAO implements BranchDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BranchMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM branch WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM branch';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM branch ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param branch primary key
     */
    public function delete($branchId) {
        $sql = 'DELETE FROM branch WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($branchId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BranchMySql branch
     */
    public function insert($branch) {
        $sql = 'INSERT INTO branch (branchName, branchDate, phone, mobile , branchNo , branchAddress,message,logo,branchTaxNo ) VALUES (?,?,?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($branch->branchName);
        $sqlQuery->set($branch->branchDate);
        $sqlQuery->set($branch->phone);
        $sqlQuery->set($branch->mobile);
        $sqlQuery->setNumber($branch->branchNo);
        $sqlQuery->set($branch->branchAddress);
        $sqlQuery->set($branch->message);
        $sqlQuery->set($branch->logo);
        $sqlQuery->set($branch->branchTaxNo);

        $id = $this->executeInsert($sqlQuery);
        $branch->branchId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BranchMySql branch
     */
    public function update($branch) {
        $sql = 'UPDATE branch SET branchName = ?, branchDate = ?, phone = ?, mobile = ? , branchNo = ? , branchAddress = ?,message=?,logo=?,branchTaxNo=? WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($branch->branchName);
        $sqlQuery->set($branch->branchDate);
        $sqlQuery->set($branch->phone);
        $sqlQuery->set($branch->mobile);
        $sqlQuery->setNumber($branch->branchNo);
        $sqlQuery->set($branch->branchAddress);
        $sqlQuery->set($branch->message);
        $sqlQuery->set($branch->logo);
        $sqlQuery->set($branch->branchTaxNo);

        $sqlQuery->setNumber($branch->branchId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM branch';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBranchName($value) {
        $sql = 'SELECT * FROM branch WHERE branchName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchDate($value) {
        $sql = 'SELECT * FROM branch WHERE branchDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBranchName($value) {
        $sql = 'DELETE FROM branch WHERE branchName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchDate($value) {
        $sql = 'DELETE FROM branch WHERE branchDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BranchMySql
     */
    protected function readRow($row) {
        $branch = new Branch();

        $branch->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $branch->branchName = isset($row['branchName']) ? $row['branchName'] : '';
        $branch->branchDate = isset($row['branchDate']) ? $row['branchDate'] : '';

        $branch->phone = isset($row['phone']) ? $row['phone'] : '';
        $branch->mobile = isset($row['mobile']) ? $row['mobile'] : '';
        $branch->branchNo = isset($row['branchNo']) ? $row['branchNo'] : '';
        $branch->branchAddress = isset($row['branchAddress']) ? $row['branchAddress'] : '';
        $branch->message = isset($row['message']) ? $row['message'] : '';
        $branch->logo = isset($row['logo']) ? $row['logo'] : '';
        $branch->branchTaxNo = isset($row['branchTaxNo']) ? $row['branchTaxNo'] : '';

        return $branch;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BranchMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>