<?php

/**
 * Class that operate on table 'billsettings'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BillsettingsMySqlDAO implements BillsettingsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsettingsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsettings WHERE billsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsettings ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsetting primary key
     */
    public function delete($billsettingsid) {
        $sql = 'DELETE FROM billsettings WHERE billsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($billsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsettingsMySql billsetting
     */
    public function insert($billsetting) {
        $sql = 'INSERT INTO billsettings (billnameid, billpropertyid, billsettingsvalue) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsetting->billnameid);
        $sqlQuery->setNumber($billsetting->billpropertyid);
        $sqlQuery->setNumber($billsetting->billsettingsvalue);

        $id = $this->executeInsert($sqlQuery);
        $billsetting->billsettingsid = $id;
        return $id;
    }

    public function replace($billsetting) {

        $sql = 'REPLACE INTO `billproperty` VALUES (billnameid, billpropertyid, billsettingsvalue) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsetting->billnameid);
        $sqlQuery->setNumber($billsetting->billpropertyid);
        $sqlQuery->setNumber($billsetting->billsettingsvalue);

        $id = $this->executeInsert($sqlQuery);
        $billsetting->billsettingsid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsettingsMySql billsetting
     */
    public function update($billsetting) {
        $sql = 'UPDATE billsettings SET billnameid = ?, billpropertyid = ?, billsettingsvalue = ? WHERE billsettingsid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsetting->billnameid);
        $sqlQuery->setNumber($billsetting->billpropertyid);
        $sqlQuery->setNumber($billsetting->billsettingsvalue);

        $sqlQuery->setNumber($billsetting->billsettingsid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsettings';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillnameid($value, $proprtyid) {
        $sql = 'SELECT * FROM billsettings WHERE billnameid = ? and billpropertyid =' . $proprtyid . '';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillpropertyid($value) {
        $sql = 'SELECT * FROM billsettings WHERE billpropertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillsettingsvalue($value) {
        $sql = 'SELECT * FROM billsettings WHERE billsettingsvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM billsettings WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillpropertyid($value) {
        $sql = 'DELETE FROM billsettings WHERE billpropertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillsettingsvalue($value) {
        $sql = 'DELETE FROM billsettings WHERE billsettingsvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsettingsMySql
     */
    protected function readRow($row) {
        $billsetting = new Billsetting();

        $billsetting->billsettingsid = isset($row['billsettingsid']) ? $row['billsettingsid'] : '';
        $billsetting->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $billsetting->billpropertyid = isset($row['billpropertyid']) ? $row['billpropertyid'] : '';
        $billsetting->billsettingsvalue = isset($row['billsettingsvalue']) ? $row['billsettingsvalue'] : '';
        $billsetting->billpropertyname = isset($row['billpropertyname']) ? $row['billpropertyname'] : '';

        return $billsetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsettingsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>