<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-03-02 22:31
 */
interface YoutubeLinkDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return YoutubeLink 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param youtubeLink primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param YoutubeLink youtubeLink
 	 */
	public function insert($youtubeLink);
	
	/**
 	 * Update record in table
 	 *
 	 * @param YoutubeLink youtubeLink
 	 */
	public function update($youtubeLink);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUrl($value);

	public function queryByStatus($value);


	public function deleteByUrl($value);

	public function deleteByStatus($value);


}
?>