<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-12-11 13:02
 */
interface SoldserialproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Soldserialproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param soldserialproduct primary key
 	 */
	public function delete($soldserialproductid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Soldserialproduct soldserialproduct
 	 */
	public function insert($soldserialproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Soldserialproduct soldserialproduct
 	 */
	public function update($soldserialproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductserailid($value);

	public function queryBySellbillid($value);

	public function queryBySellbilltype($value);

	public function queryByQuantity($value);


	public function deleteByProductserailid($value);

	public function deleteBySellbillid($value);

	public function deleteBySellbilltype($value);

	public function deleteByQuantity($value);


}
?>