<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-25 14:24
 */
interface ShippercompaniesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Shippercompanies 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param shippercompanie primary key
 	 */
	public function delete($companyId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Shippercompanies shippercompanie
 	 */
	public function insert($shippercompanie, $otherInfo);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Shippercompanies shippercompanie
 	 */
	public function update($shippercompanie, $otherInfo);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompanyName($value);

	public function queryByOtherInfo($value);

	public function queryByTempdele($value);


	public function deleteByCompanyName($value);

	public function deleteByOtherInfo($value);

	public function deleteByTempdele($value);


}
?>