<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:06
 */
interface RentproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rentproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rentproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rentproduct rentproduct
 	 */
	public function insert($rentproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rentproduct rentproduct
 	 */
	public function update($rentproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByQuantity($value);

	public function queryByBuyprice($value);

	public function queryByTotalprice($value);

	public function queryByRentprice($value);

	public function queryByPaytype($value);

	public function queryBySupplierid($value);

	public function queryByCreatedate($value);


	public function deleteByName($value);

	public function deleteByQuantity($value);

	public function deleteByBuyprice($value);

	public function deleteByTotalprice($value);

	public function deleteByRentprice($value);

	public function deleteByPaytype($value);

	public function deleteBySupplierid($value);

	public function deleteByCreatedate($value);


}
?>