<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-05-07 12:40
 */
interface ProducttempunitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Producttempunit 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param producttempunit primary key
 	 */
	public function delete($producttempunitid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Producttempunit producttempunit
 	 */
	public function insert($producttempunit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Producttempunit producttempunit
 	 */
	public function update($producttempunit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUnitid($value);

	public function queryByProducttempid($value);

	public function queryByProductnumber($value);

	public function queryByProducttempunitdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteByUnitid($value);

	public function deleteByProducttempid($value);

	public function deleteByProductnumber($value);

	public function deleteByProducttempunitdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>