<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-09-08 11:49
 */
interface ProductshowDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productshow 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productshow primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productshow productshow
 	 */
	public function insert($productshow);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productshow productshow
 	 */
	public function update($productshow);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByMydate($value);

	public function queryByClientid($value);

	public function queryByTimenow($value);

	public function queryByUserid($value);

	public function queryByDel($value);


	public function deleteByMydate($value);

	public function deleteByClientid($value);

	public function deleteByTimenow($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);


}
?>