<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:59
 */
interface ProductionexecutionwasteDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionexecutionwaste 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionexecutionwaste primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionexecutionwaste productionexecutionwaste
 	 */
	public function insert($productionexecutionwaste);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionexecutionwaste productionexecutionwaste
 	 */
	public function update($productionexecutionwaste);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExecutionid($value);

	public function queryByProductid($value);

	public function queryByAllprice($value);

	public function queryByHalfprice($value);

	public function queryByUnitprice($value);

	public function queryByNum($value);

	public function queryByStoreid($value);


	public function deleteByExecutionid($value);

	public function deleteByProductid($value);

	public function deleteByAllprice($value);

	public function deleteByHalfprice($value);

	public function deleteByUnitprice($value);

	public function deleteByNum($value);

	public function deleteByStoreid($value);


}
?>