<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-04-25 01:52
 */
interface PremiumInstallmentsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return PremiumInstallments 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param premiumInstallment primary key
 	 */
	public function delete($id_installment);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PremiumInstallments premiumInstallment
 	 */
	public function insert($premiumInstallment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param PremiumInstallments premiumInstallment
 	 */
	public function update($premiumInstallment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDate($value);

	public function queryByValue($value);

	public function queryByPremiumauoId($value);

	public function queryByPayed($value);

	public function queryByConditions($value);


	public function deleteByDate($value);

	public function deleteByValue($value);

	public function deleteByPremiumauoId($value);

	public function deleteByPayed($value);

	public function deleteByConditions($value);


}
?>