<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-04-04 21:17
 */
interface PremiumDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Premium 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param premium primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Premium premium
 	 */
	public function insert($premium);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Premium premium
 	 */
	public function update($premium);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDate($value);

	public function queryByValue($value);

	public function queryByPremiumclientId($value);


	public function deleteByDate($value);

	public function deleteByValue($value);

	public function deleteByPremiumclientId($value);


}
?>