<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
interface OnlinetemporderproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetemporderproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetemporderproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetemporderproduct onlinetemporderproduct
 	 */
	public function insert($onlinetemporderproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetemporderproduct onlinetemporderproduct
 	 */
	public function update($onlinetemporderproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrderid($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByPrice($value);

	public function queryByQuantity($value);

	public function queryByShippingcost($value);

	public function queryByTotal($value);

	public function queryByOrderstatus($value);

	public function queryByShippingtype($value);

	public function queryByDiscountprice($value);


	public function deleteByOrderid($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByPrice($value);

	public function deleteByQuantity($value);

	public function deleteByShippingcost($value);

	public function deleteByTotal($value);

	public function deleteByOrderstatus($value);

	public function deleteByShippingtype($value);

	public function deleteByDiscountprice($value);


}
?>