<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-09-13 19:39
 */
interface FaidaproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Faidaproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param faidaproduct primary key
 	 */
	public function delete($faida_prod_id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Faidaproduct faidaproduct
 	 */
	public function insert($faidaproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Faidaproduct faidaproduct
 	 */
	public function update($faidaproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParcode($value);

	public function queryByStoryId($value);

	public function queryByComment($value);

	public function queryByProductunit($value);

	public function queryByPronum($value);

	public function queryByScunitname($value);

	public function queryByBouns($value);

	public function queryByPricetypepro($value);

	public function queryByProprice($value);

	public function queryByDiscounttype($value);

	public function queryByFaidaId($value);

	public function queryByConditions($value);


	public function deleteByParcode($value);

	public function deleteByStoryId($value);

	public function deleteByComment($value);

	public function deleteByProductunit($value);

	public function deleteByPronum($value);

	public function deleteByScunitname($value);

	public function deleteByBouns($value);

	public function deleteByPricetypepro($value);

	public function deleteByProprice($value);

	public function deleteByDiscounttype($value);

	public function deleteByFaidaId($value);

	public function deleteByConditions($value);


}
?>