<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-04-03 14:19
 */
interface EbillsettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Ebillsetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param ebillsetting primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Ebillsetting ebillsetting
 	 */
	public function insert($ebillsetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Ebillsetting ebillsetting
 	 */
	public function update($ebillsetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByETaxNum($value);

	public function queryByETaxNumBranch($value);

	public function queryByEGovernorate($value);

	public function queryByECity($value);

	public function queryByEStreet($value);

	public function queryByEBuildingNum($value);

	public function queryByETaxType($value);

	public function queryByETaxTypeNum($value);

	public function queryByECompanyNameInTaxCard($value);


	public function deleteByETaxNum($value);

	public function deleteByETaxNumBranch($value);

	public function deleteByEGovernorate($value);

	public function deleteByECity($value);

	public function deleteByEStreet($value);

	public function deleteByEBuildingNum($value);

	public function deleteByETaxType($value);

	public function deleteByETaxTypeNum($value);

	public function deleteByECompanyNameInTaxCard($value);


}
?>