<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BuybilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buybilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buybilldetail primary key
 	 */
	public function delete($buybilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buybilldetail buybilldetail
 	 */
	public function insert($buybilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buybilldetail buybilldetail
 	 */
	public function update($buybilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParcode($value);

	public function queryByBuybillid($value);

	public function queryByBuybilldetailcatid($value);

	public function queryByBuybilldetailproductid($value);

	public function queryByBuybilldetailquantity($value);

	public function queryByBuybilldetailprice($value);

	public function queryByBuybilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);


	public function deleteByParcode($value);

	public function deleteByBuybillid($value);

	public function deleteByBuybilldetailcatid($value);

	public function deleteByBuybilldetailproductid($value);

	public function deleteByBuybilldetailquantity($value);

	public function deleteByBuybilldetailprice($value);

	public function deleteByBuybilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);


}
?>